/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.jackson.mixin.IgnoreOriginalRefMixin;
import io.swagger.jackson.mixin.OriginalRefMixin;
import io.swagger.models.RefModel;
import io.swagger.models.RefPath;
import io.swagger.models.RefResponse;
import io.swagger.models.parameters.RefParameter;
import io.swagger.models.properties.RefProperty;
import io.swagger.util.Json;
import io.swagger.util.Yaml;

public abstract class ReferenceSerializationConfigurer {
    private static void serializeAs(Class<?> cls, ObjectMapper mapper) {
        mapper.addMixIn(RefModel.class, cls);
        mapper.addMixIn(RefProperty.class, cls);
        mapper.addMixIn(RefPath.class, cls);
        mapper.addMixIn(RefParameter.class, cls);
        mapper.addMixIn(RefResponse.class, cls);
    }

    public static void serializeAsOriginalRef() {
        ReferenceSerializationConfigurer.serializeAs(OriginalRefMixin.class, Json.mapper());
        ReferenceSerializationConfigurer.serializeAs(OriginalRefMixin.class, Yaml.mapper());
    }

    public static void serializeAsComputedRef() {
        ReferenceSerializationConfigurer.serializeAs(IgnoreOriginalRefMixin.class, Json.mapper());
        ReferenceSerializationConfigurer.serializeAs(IgnoreOriginalRefMixin.class, Yaml.mapper());
    }

    public static void serializeAsOriginalRef(ObjectMapper mapper) {
        ReferenceSerializationConfigurer.serializeAs(OriginalRefMixin.class, mapper);
    }

    public static void serializeAsComputedRef(ObjectMapper mapper) {
        ReferenceSerializationConfigurer.serializeAs(IgnoreOriginalRefMixin.class, mapper);
    }
}

