/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations;

import java.util.Objects;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.execution.warnings.WarningCollector;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Analysis;
import org.apache.iotdb.db.queryengine.plan.relational.execution.querystats.PlanOptimizersStatsCollector;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.Metadata;
import org.apache.iotdb.db.queryengine.plan.relational.planner.SymbolAllocator;

public interface PlanOptimizer {
    public PlanNode optimize(PlanNode var1, Context var2);

    public static class Context {
        private final SessionInfo sessionInfo;
        private final Analysis analysis;
        private final Metadata metadata;
        private final MPPQueryContext queryContext;
        private final SymbolAllocator symbolAllocator;
        private final QueryId queryIdAllocator;
        private final WarningCollector warningCollector;
        private final PlanOptimizersStatsCollector planOptimizersStatsCollector;

        public Context(SessionInfo sessionInfo, Analysis analysis, Metadata metadata, MPPQueryContext queryContext, SymbolAllocator symbolAllocator, QueryId queryIdAllocator, WarningCollector warningCollector, PlanOptimizersStatsCollector planOptimizersStatsCollector) {
            this.sessionInfo = sessionInfo;
            this.analysis = analysis;
            this.metadata = metadata;
            this.queryContext = queryContext;
            this.symbolAllocator = Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
            this.queryIdAllocator = Objects.requireNonNull(queryIdAllocator, "idAllocator is null");
            this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
            this.planOptimizersStatsCollector = Objects.requireNonNull(planOptimizersStatsCollector, "planOptimizersStatsCollector is null");
        }

        public SessionInfo sessionInfo() {
            return this.sessionInfo;
        }

        public Analysis getAnalysis() {
            return this.analysis;
        }

        public Metadata getMetadata() {
            return this.metadata;
        }

        public MPPQueryContext getQueryContext() {
            return this.queryContext;
        }

        public SymbolAllocator getSymbolAllocator() {
            return this.symbolAllocator;
        }

        public QueryId idAllocator() {
            return this.queryIdAllocator;
        }

        public WarningCollector warningCollector() {
            return this.warningCollector;
        }

        public PlanOptimizersStatsCollector planOptimizersStatsCollector() {
            return this.planOptimizersStatsCollector;
        }
    }
}

