/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.persistence;

import io.moquette.broker.Utils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.BasicDataType;

public final class ByteBufDataType
extends BasicDataType<ByteBuf> {
    public int compare(ByteBuf a, ByteBuf b) {
        throw DataUtils.newUnsupportedOperationException((String)"Can not compare");
    }

    public int getMemory(ByteBuf obj) {
        if (!(obj instanceof ByteBuf)) {
            throw new IllegalArgumentException("Expected instance of ByteBuf but found " + obj.getClass());
        }
        int payloadSize = obj.readableBytes();
        return 4 + payloadSize;
    }

    public ByteBuf read(ByteBuffer buff) {
        int payloadSize = buff.getInt();
        byte[] payload = new byte[payloadSize];
        buff.get(payload);
        return Unpooled.wrappedBuffer((byte[])payload);
    }

    public void write(WriteBuffer buff, ByteBuf obj) {
        int payloadSize = obj.readableBytes();
        byte[] rawBytes = new byte[payloadSize];
        ByteBuf copiedBuffer = obj.copy().readBytes(rawBytes);
        Utils.release(copiedBuffer, "temp copy buffer");
        buff.putInt(payloadSize);
        buff.put(rawBytes);
    }

    public ByteBuf[] createStorage(int i) {
        return new ByteBuf[i];
    }
}

