/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.metric;

import java.util.Arrays;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.queryengine.execution.exchange.MPPDataExchangeManager;
import org.apache.iotdb.db.queryengine.execution.exchange.MPPDataExchangeService;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.impl.DoNothingMetricManager;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.type.Histogram;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class DataExchangeCountMetricSet
implements IMetricSet {
    private static final DataExchangeCountMetricSet INSTANCE = new DataExchangeCountMetricSet();
    public static final String CALLER = "caller";
    public static final String SERVER = "server";
    private static final String SEND_NEW_DATA_BLOCK_NUM = "send_new_data_block_num";
    public static final String SEND_NEW_DATA_BLOCK_NUM_CALLER = "send_new_data_block_num_caller";
    public static final String SEND_NEW_DATA_BLOCK_NUM_SERVER = "send_new_data_block_num_server";
    private static final String ON_ACKNOWLEDGE_DATA_BLOCK_NUM = "on_acknowledge_data_block_num";
    public static final String ON_ACKNOWLEDGE_DATA_BLOCK_NUM_CALLER = "on_acknowledge_data_block_num_caller";
    public static final String ON_ACKNOWLEDGE_DATA_BLOCK_NUM_SERVER = "on_acknowledge_data_block_num_server";
    private static final String GET_DATA_BLOCK_NUM = "get_data_block_num";
    public static final String GET_DATA_BLOCK_NUM_CALLER = "get_data_block_num_caller";
    public static final String GET_DATA_BLOCK_NUM_SERVER = "get_data_block_num_server";
    private static final MPPDataExchangeManager dataExchangeManager = MPPDataExchangeService.getInstance().getMPPDataExchangeManager();
    private static final String SHUFFLE_SINK_HANDLE_SIZE = "shuffle_sink_handle_size";
    private static final String SOURCE_HANDLE_SIZE = "source_handle_size";
    private Histogram sendNewDataBlockNumCallerHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram sendNewDataBlockNumServerHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram onAcknowledgeDataBlockNumCallerHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram onAcknowledgeDataBlockNumServerHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram getDataBlockNumCallerHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
    private Histogram getDataBlockNumServerHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;

    private DataExchangeCountMetricSet() {
    }

    public void bindTo(AbstractMetricService metricService) {
        this.sendNewDataBlockNumCallerHistogram = metricService.getOrCreateHistogram(Metric.DATA_EXCHANGE_COUNT.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), SEND_NEW_DATA_BLOCK_NUM, Tag.TYPE.toString(), CALLER});
        this.sendNewDataBlockNumServerHistogram = metricService.getOrCreateHistogram(Metric.DATA_EXCHANGE_COUNT.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), SEND_NEW_DATA_BLOCK_NUM, Tag.TYPE.toString(), SERVER});
        this.onAcknowledgeDataBlockNumCallerHistogram = metricService.getOrCreateHistogram(Metric.DATA_EXCHANGE_COUNT.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), ON_ACKNOWLEDGE_DATA_BLOCK_NUM, Tag.TYPE.toString(), CALLER});
        this.onAcknowledgeDataBlockNumServerHistogram = metricService.getOrCreateHistogram(Metric.DATA_EXCHANGE_COUNT.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), ON_ACKNOWLEDGE_DATA_BLOCK_NUM, Tag.TYPE.toString(), SERVER});
        this.getDataBlockNumCallerHistogram = metricService.getOrCreateHistogram(Metric.DATA_EXCHANGE_COUNT.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), GET_DATA_BLOCK_NUM, Tag.TYPE.toString(), CALLER});
        this.getDataBlockNumServerHistogram = metricService.getOrCreateHistogram(Metric.DATA_EXCHANGE_COUNT.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), GET_DATA_BLOCK_NUM, Tag.TYPE.toString(), SERVER});
        metricService.createAutoGauge(Metric.DATA_EXCHANGE_SIZE.toString(), MetricLevel.IMPORTANT, (Object)dataExchangeManager, MPPDataExchangeManager::getShuffleSinkHandleSize, new String[]{Tag.NAME.toString(), SHUFFLE_SINK_HANDLE_SIZE});
        metricService.createAutoGauge(Metric.DATA_EXCHANGE_SIZE.toString(), MetricLevel.IMPORTANT, (Object)dataExchangeManager, MPPDataExchangeManager::getSourceHandleSize, new String[]{Tag.NAME.toString(), SOURCE_HANDLE_SIZE});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        this.sendNewDataBlockNumCallerHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
        this.sendNewDataBlockNumServerHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
        this.onAcknowledgeDataBlockNumCallerHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
        this.onAcknowledgeDataBlockNumServerHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
        this.getDataBlockNumCallerHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
        this.getDataBlockNumServerHistogram = DoNothingMetricManager.DO_NOTHING_HISTOGRAM;
        Arrays.asList(SEND_NEW_DATA_BLOCK_NUM, ON_ACKNOWLEDGE_DATA_BLOCK_NUM, GET_DATA_BLOCK_NUM).forEach(name -> Arrays.asList(CALLER, SERVER).forEach(caller -> metricService.remove(MetricType.HISTOGRAM, Metric.DATA_EXCHANGE_COUNT.toString(), new String[]{Tag.NAME.toString(), name, Tag.TYPE.toString(), caller})));
        metricService.remove(MetricType.AUTO_GAUGE, Metric.DATA_EXCHANGE_SIZE.toString(), new String[]{Tag.NAME.toString(), SHUFFLE_SINK_HANDLE_SIZE});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.DATA_EXCHANGE_SIZE.toString(), new String[]{Tag.NAME.toString(), SOURCE_HANDLE_SIZE});
    }

    public void recordDataBlockNum(String type, int num) {
        switch (type) {
            case "send_new_data_block_num_caller": {
                this.sendNewDataBlockNumCallerHistogram.update((long)num);
                break;
            }
            case "send_new_data_block_num_server": {
                this.sendNewDataBlockNumServerHistogram.update((long)num);
                break;
            }
            case "on_acknowledge_data_block_num_caller": {
                this.onAcknowledgeDataBlockNumCallerHistogram.update((long)num);
                break;
            }
            case "on_acknowledge_data_block_num_server": {
                this.onAcknowledgeDataBlockNumServerHistogram.update((long)num);
                break;
            }
            case "get_data_block_num_caller": {
                this.getDataBlockNumCallerHistogram.update((long)num);
                break;
            }
            case "get_data_block_num_server": {
                this.getDataBlockNumServerHistogram.update((long)num);
                break;
            }
        }
    }

    public static DataExchangeCountMetricSet getInstance() {
        return INSTANCE;
    }
}

