/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.util;

import java.nio.charset.Charset;
import org.apache.james.mime4j.Charsets;
import org.apache.james.mime4j.util.CharsetUtil;
import org.junit.Assert;
import org.junit.Test;

public class CharsetUtilTest {
    private static final String SWISS_GERMAN_HELLO = "Gr\u00fcezi_z\u00e4m\u00e4";
    private static final String RUSSIAN_HELLO = "\u0412\u0441\u0435\u043c_\u043f\u0440\u0438\u0432\u0435\u0442";

    @Test
    public void testAllASCII() {
        String s = "Like hello and stuff";
        Assert.assertTrue((boolean)CharsetUtil.isASCII((String)s));
    }

    @Test
    public void testNonASCII() {
        Assert.assertFalse((boolean)CharsetUtil.isASCII((String)SWISS_GERMAN_HELLO));
        Assert.assertFalse((boolean)CharsetUtil.isASCII((String)RUSSIAN_HELLO));
    }

    @Test
    public void testCharsetLookup() {
        Charset c1 = CharsetUtil.lookup((String)"us-ascii");
        Charset c2 = CharsetUtil.lookup((String)"ascii");
        Assert.assertEquals((Object)Charsets.US_ASCII, (Object)c1);
        Assert.assertEquals((Object)Charsets.US_ASCII, (Object)c2);
    }

    @Test
    public void testCharsetLookupNullInput() {
        Charset c1 = CharsetUtil.lookup(null);
        Assert.assertNull((Object)c1);
    }

    @Test
    public void testCharsetLookupFailure() {
        Charset c1 = CharsetUtil.lookup((String)"whatever");
        Assert.assertNull((Object)c1);
    }
}

