/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.http;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.core.Username;
import org.apache.james.jmap.exceptions.UnauthorizedException;
import org.apache.james.jmap.http.AuthenticationChallenge;
import org.apache.james.jmap.http.AuthenticationScheme;
import org.apache.james.jmap.http.AuthenticationStrategy;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.utils.PropertiesProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.netty.http.server.HttpServerRequest;

public class XUserAuthenticationStrategy
implements AuthenticationStrategy {
    private static final String X_USER_HEADER_NAME = "X-User";
    private static final String X_USER_SECRET_HEADER_NAME = "X-User-Secret";
    private static final String AUTHENTICATION_STRATEGY_XUSER_SECRET = "authentication.strategy.rfc8621.xUser.secret";
    private static final Logger LOGGER = LoggerFactory.getLogger(XUserAuthenticationStrategy.class);
    private static final AuthenticationChallenge X_USER_CHALLENGE = AuthenticationChallenge.of(AuthenticationScheme.of("XUserHeader"), (Map<String, String>)ImmutableMap.of());
    private final UsersRepository usersRepository;
    private final MailboxManager mailboxManager;
    private final Function<HttpServerRequest, Optional<Username>> usernameExtractor;

    private static Optional<List<String>> extractXUserSecretFromConfig(PropertiesProvider propertiesProvider) throws ConfigurationException {
        try {
            return Optional.ofNullable(propertiesProvider.getConfiguration("jmap")).map(config -> config.getList(String.class, AUTHENTICATION_STRATEGY_XUSER_SECRET, null)).map(list -> {
                Preconditions.checkArgument((!list.isEmpty() ? 1 : 0) != 0, (Object)"authentication.strategy.rfc8621.xUser.secret must not be empty");
                return list;
            });
        }
        catch (FileNotFoundException e) {
            return Optional.empty();
        }
    }

    @Inject
    public XUserAuthenticationStrategy(UsersRepository usersRepository, MailboxManager mailboxManager, PropertiesProvider configuration) throws ConfigurationException {
        this(usersRepository, mailboxManager, XUserAuthenticationStrategy.extractXUserSecretFromConfig(configuration));
    }

    public XUserAuthenticationStrategy(UsersRepository usersRepository, MailboxManager mailboxManager, Optional<List<String>> xUserSecret) {
        this.usersRepository = usersRepository;
        this.mailboxManager = mailboxManager;
        this.usernameExtractor = xUserSecret.map(this::createUsernameExtractorWithSecretValidation).orElseGet(() -> {
            LOGGER.warn("No X-User-Secret value found. X-User header will be used without secret validation which can pose a security risk if an attacker gains access to the JMAP endpoint. Secret validation can be set up via the authentication.strategy.rfc8621.xUser.secret jmap configuration property.");
            return this.createUsernameExtractorWithoutSecretValidation();
        });
    }

    @Override
    public Mono<MailboxSession> createMailboxSession(HttpServerRequest httpRequest) {
        return this.usernameExtractor.apply(httpRequest).map(this::createMailboxSession).orElse(Mono.empty());
    }

    private Mono<MailboxSession> createMailboxSession(Username username) {
        return this.usersRepository.assertValidReactive(username).onErrorMap(e -> new UnauthorizedException("Invalid username", (Throwable)e)).then(Mono.fromCallable(() -> this.mailboxManager.authenticate(username).withoutDelegation()));
    }

    @Override
    public AuthenticationChallenge correspondingChallenge() {
        return X_USER_CHALLENGE;
    }

    private Function<HttpServerRequest, Optional<Username>> createUsernameExtractorWithoutSecretValidation() {
        return httpRequest -> Optional.ofNullable(httpRequest.requestHeaders().get(X_USER_HEADER_NAME)).map(String::trim).filter(s -> !s.isEmpty()).map(Username::of);
    }

    private Function<HttpServerRequest, Optional<Username>> createUsernameExtractorWithSecretValidation(List<String> validatedSecretList) {
        return httpRequest -> this.createUsernameExtractorWithoutSecretValidation().apply((HttpServerRequest)httpRequest).filter(username -> Optional.ofNullable(httpRequest.requestHeaders().get(X_USER_SECRET_HEADER_NAME)).map(validatedSecretList::contains).orElse(false));
    }
}

