/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.quota;

import jakarta.inject.Inject;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.model.CurrentQuotas;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CurrentQuotaCalculator {
    private static final int NO_CONCURRENCY = 1;
    private final MailboxSessionMapperFactory factory;
    private final QuotaRootResolver quotaRootResolver;

    @Inject
    public CurrentQuotaCalculator(MailboxSessionMapperFactory factory, QuotaRootResolver quotaRootResolver) {
        this.factory = factory;
        this.quotaRootResolver = quotaRootResolver;
    }

    public Mono<CurrentQuotas> recalculateCurrentQuotas(QuotaRoot quotaRoot, MailboxSession session) {
        MessageMapper mapper = this.factory.getMessageMapper(session);
        return Flux.from((Publisher)this.quotaRootResolver.retrieveAssociatedMailboxes(quotaRoot, session)).flatMap(mailbox -> mapper.findInMailboxReactive((Mailbox)mailbox, MessageRange.all(), MessageMapper.FetchType.METADATA, -1), 1).map(message -> new CurrentQuotas(QuotaCountUsage.count((long)1L), QuotaSizeUsage.size((long)message.getFullContentOctets()))).reduce((Object)CurrentQuotas.emptyQuotas(), CurrentQuotas::increase);
    }
}

