/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.time;

import com.datastax.oss.driver.internal.core.os.Native;
import com.datastax.oss.driver.internal.core.time.JavaClock;
import com.datastax.oss.driver.internal.core.time.NativeClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Clock {
    public static final Logger LOG = LoggerFactory.getLogger(Clock.class);

    public static Clock getInstance(boolean forceJavaClock) {
        if (forceJavaClock) {
            LOG.info("Using Java system clock because this was explicitly required in the configuration");
            return new JavaClock();
        }
        if (!Native.isCurrentTimeMicrosAvailable()) {
            LOG.info("Could not access native clock (see debug logs for details), falling back to Java system clock");
            return new JavaClock();
        }
        LOG.info("Using native clock for microsecond precision");
        return new NativeClock();
    }

    public long currentTimeMicros();
}

