/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 *   SPDX-License-Identifier: Apache-2.0
 */

package org.apache.jena.riot.system;

import java.util.ArrayList;
import java.util.List;

import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Quad;

public class CatchParserOutput implements StreamRDF
{
    public List<Triple>      triples     = new ArrayList<>();
    public List<Quad>        quads       = new ArrayList<>();
    public List<Pair<String,String>>     prefixes     = new ArrayList<>();
    public List<String>     bases       = new ArrayList<>();
    public List<String>     versions    = new ArrayList<>();

    public int startCalled = 0;

    public int finishCalled = 0;

    @Override public void start()   { startCalled++; }

    @Override public void triple(Triple triple)     { triples.add(triple); }

    @Override public void quad(Quad quad)           { quads.add(quad); }

    @Override public void base(String base)         { bases.add(base); }

    @Override public void prefix(String prefix, String iri) { prefixes.add(Pair.create(prefix, iri)); }

    @Override public void version(String version)   { versions.add(version); }

    @Override public void finish()  { finishCalled++; }
}
