/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.parser;

import java.util.List;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;

public class Position {
    static final Position UNKNOWN = new Position(-1);
    int line;
    int column;
    int position;

    public Position(int position) {
        this.line = -1;
        this.column = -1;
        this.position = position;
    }

    public Position(int line, int column) {
        this.line = line;
        this.column = column;
        this.position = -1;
    }

    public int getColumn() {
        return this.column;
    }

    public int getLine() {
        return this.line;
    }

    public int getPosition() {
        return this.position;
    }

    public String toString() {
        List<String> l = CollectionUtils.list(new String[0]);
        if (this.line != -1) {
            l.add("line " + this.line);
        }
        if (this.column != -1) {
            l.add("column " + this.column);
        }
        if (this.position != -1) {
            l.add("position " + this.position);
        }
        if (l.isEmpty()) {
            l.add("unknown");
        }
        return StringUtils.join(l, ", ");
    }
}

