/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.spi.impl;

import jakarta.faces.context.ExternalContext;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.flow.cdi.DefaultCDIFacesFlowProvider;
import org.apache.myfaces.flow.impl.DefaultFacesFlowProvider;
import org.apache.myfaces.spi.FacesFlowProvider;
import org.apache.myfaces.spi.FacesFlowProviderFactory;
import org.apache.myfaces.spi.ServiceProviderFinderFactory;
import org.apache.myfaces.util.ExternalSpecifications;
import org.apache.myfaces.util.lang.ClassUtils;

public class DefaultFacesFlowProviderFactory
extends FacesFlowProviderFactory {
    public static final String FACES_FLOW_PROVIDER = FacesFlowProvider.class.getName();
    public static final String FACES_FLOW_PROVIDER_INSTANCE_KEY = FACES_FLOW_PROVIDER + ".INSTANCE";

    @Override
    public FacesFlowProvider getFacesFlowProvider(ExternalContext externalContext) {
        FacesFlowProvider instance = (FacesFlowProvider)externalContext.getApplicationMap().get(FACES_FLOW_PROVIDER_INSTANCE_KEY);
        if (instance == null) {
            try {
                instance = this.resolveFacesFlowProviderFromService(externalContext);
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "", e);
            }
            if (instance == null) {
                instance = ExternalSpecifications.isCDIAvailable(externalContext) ? new DefaultCDIFacesFlowProvider() : new DefaultFacesFlowProvider();
            }
            externalContext.getApplicationMap().put(FACES_FLOW_PROVIDER_INSTANCE_KEY, instance);
        }
        return instance;
    }

    private FacesFlowProvider resolveFacesFlowProviderFromService(ExternalContext externalContext) throws Exception {
        List<String> classList = ServiceProviderFinderFactory.getServiceProviderFinder(externalContext).getServiceProviderList(FACES_FLOW_PROVIDER);
        return ClassUtils.buildApplicationObject(FacesFlowProvider.class, classList, null);
    }

    private Logger getLogger() {
        return Logger.getLogger(DefaultFacesFlowProviderFactory.class.getName());
    }
}

