/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.nar;

import java.util.Objects;
import org.apache.nifi.minifi.nar.NarAutoUnloaderTask;
import org.apache.nifi.minifi.nar.NarAutoUnloaderTaskFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NarAutoUnloader {
    private static final Logger LOGGER = LoggerFactory.getLogger(NarAutoUnloader.class);
    private final NarAutoUnloaderTaskFactory narAutoUnloaderTaskFactory;
    private NarAutoUnloaderTask narAutoUnLoaderTask;
    private boolean started = false;

    public NarAutoUnloader(NarAutoUnloaderTaskFactory narAutoUnloaderTaskFactory) {
        this.narAutoUnloaderTaskFactory = Objects.requireNonNull(narAutoUnloaderTaskFactory);
    }

    public synchronized void start() throws Exception {
        if (!this.started) {
            this.narAutoUnLoaderTask = this.narAutoUnloaderTaskFactory.createNarAutoUnloaderTask();
            LOGGER.info("Starting NAR Auto-Unloader Thread for directory {}", (Object)this.narAutoUnLoaderTask.getAutoLoadPath());
            Thread.ofVirtual().name("NAR Auto-Unloader").start(this.narAutoUnLoaderTask);
            this.started = true;
        }
    }

    public synchronized void stop() {
        this.started = false;
        if (this.narAutoUnLoaderTask != null) {
            this.narAutoUnLoaderTask.stop();
            this.narAutoUnLoaderTask = null;
        }
        LOGGER.info("NAR Auto-Unloader stopped");
    }
}

