/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.StandardEvaluationContext;
import org.apache.nifi.attribute.expression.language.evaluation.DateEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.literals.StringLiteralEvaluator;

public class FormatEvaluator
extends StringEvaluator {
    private final DateEvaluator subject;
    private final Evaluator<String> format;
    private final Evaluator<String> timeZone;
    private final DateTimeFormatter preparedFormatter;
    private final boolean preparedFormatterHasRequestedTimeZone;

    public FormatEvaluator(DateEvaluator subject, Evaluator<String> format, Evaluator<String> timeZone) {
        this.subject = subject;
        this.format = format;
        if (format instanceof StringLiteralEvaluator) {
            String formatPattern = format.evaluate(new StandardEvaluationContext(Collections.emptyMap())).getValue();
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern(formatPattern, Locale.US);
            if (timeZone == null) {
                this.preparedFormatter = dtf;
                this.preparedFormatterHasRequestedTimeZone = true;
            } else if (timeZone instanceof StringLiteralEvaluator) {
                this.preparedFormatter = dtf.withZone(ZoneId.of(timeZone.evaluate(new StandardEvaluationContext(Collections.emptyMap())).getValue()));
                this.preparedFormatterHasRequestedTimeZone = true;
            } else {
                this.preparedFormatter = dtf;
                this.preparedFormatterHasRequestedTimeZone = false;
            }
        } else {
            this.preparedFormatter = null;
            this.preparedFormatterHasRequestedTimeZone = false;
        }
        this.timeZone = timeZone;
    }

    @Override
    public QueryResult<String> evaluate(EvaluationContext evaluationContext) {
        QueryResult<String> tzResult;
        String tz;
        DateTimeFormatter dtf;
        Date subjectValue = (Date)this.subject.evaluate(evaluationContext).getValue();
        if (subjectValue == null) {
            return new StringQueryResult(null);
        }
        if (this.preparedFormatter == null) {
            QueryResult<String> formatResult = this.format.evaluate(evaluationContext);
            String format = formatResult.getValue();
            if (format == null) {
                return null;
            }
            dtf = DateTimeFormatter.ofPattern(format, Locale.US);
        } else {
            dtf = this.preparedFormatter;
        }
        if (!(this.preparedFormatter != null && this.preparedFormatterHasRequestedTimeZone || this.timeZone == null || (tz = (tzResult = this.timeZone.evaluate(evaluationContext)).getValue()) == null)) {
            dtf = dtf.withZone(ZoneId.of(tz));
        }
        ZonedDateTime subjectDateTime = subjectValue.toInstant().atZone(ZoneId.systemDefault());
        return new StringQueryResult(dtf.format(subjectDateTime));
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

