/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.s3express;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SelectedAuthScheme;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.core.useragent.BusinessMetricFeatureId;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.services.s3.endpoints.internal.KnownS3ExpressEndpointProperty;

@SdkInternalApi
public final class S3ExpressUtils {
    public static final String S3_EXPRESS = "S3Express";

    private S3ExpressUtils() {
    }

    public static boolean useS3Express(ExecutionAttributes executionAttributes) {
        Endpoint endpoint = (Endpoint)executionAttributes.getAttribute(SdkInternalExecutionAttribute.RESOLVED_ENDPOINT);
        if (endpoint != null) {
            String useS3Express = (String)endpoint.attribute(KnownS3ExpressEndpointProperty.BACKEND);
            return S3_EXPRESS.equals(useS3Express);
        }
        return false;
    }

    public static boolean useS3ExpressAuthScheme(ExecutionAttributes executionAttributes) {
        SelectedAuthScheme selectedAuthScheme = (SelectedAuthScheme)executionAttributes.getAttribute(SdkInternalExecutionAttribute.SELECTED_AUTH_SCHEME);
        if (selectedAuthScheme != null) {
            AuthSchemeOption authSchemeOption = selectedAuthScheme.authSchemeOption();
            return "aws.auth#sigv4-s3express".equals(authSchemeOption.schemeId());
        }
        return false;
    }

    public static void addS3ExpressBusinessMetricIfApplicable(ExecutionAttributes executionAttributes) {
        if (executionAttributes != null && S3ExpressUtils.useS3Express(executionAttributes) && S3ExpressUtils.useS3ExpressAuthScheme(executionAttributes)) {
            executionAttributes.getOptionalAttribute(SdkInternalExecutionAttribute.BUSINESS_METRICS).ifPresent(businessMetrics -> businessMetrics.addMetric(BusinessMetricFeatureId.S3_EXPRESS_BUCKET.value()));
        }
    }
}

