/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap.command;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.nifi.minifi.bootstrap.Status;
import org.apache.nifi.minifi.bootstrap.command.CommandRunner;

public class CompositeCommandRunner
implements CommandRunner {
    final List<CommandRunner> services;

    public CompositeCommandRunner(List<CommandRunner> services) {
        this.services = Optional.ofNullable(services).map(Collections::unmodifiableList).orElse(Collections.emptyList());
    }

    @Override
    public int runCommand(String[] args) {
        return this.services.stream().map(service -> service.runCommand(args)).filter(code -> code.intValue() != Status.OK.getStatusCode()).findFirst().orElse(Status.OK.getStatusCode());
    }
}

