/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.bootstrap;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.nar.NarClassLoader;
import org.apache.nifi.nar.NarUnpackMode;
import org.apache.nifi.nar.NarUnpacker;
import org.apache.nifi.nar.SystemBundle;
import org.apache.nifi.stateless.bootstrap.AllowListClassLoader;
import org.apache.nifi.stateless.config.ParameterOverride;
import org.apache.nifi.stateless.config.StatelessConfigurationException;
import org.apache.nifi.stateless.engine.NarUnpackLock;
import org.apache.nifi.stateless.engine.StatelessEngineConfiguration;
import org.apache.nifi.stateless.flow.DataflowDefinition;
import org.apache.nifi.stateless.flow.DataflowDefinitionParser;
import org.apache.nifi.stateless.flow.StatelessDataflow;
import org.apache.nifi.stateless.flow.StatelessDataflowFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatelessBootstrap {
    private static final Logger logger = LoggerFactory.getLogger(StatelessBootstrap.class);
    private static final Pattern STATELESS_NAR_PATTERN = Pattern.compile("nifi-stateless-nar-.*\\.nar-unpacked");
    private final ClassLoader engineClassLoader;
    private final ClassLoader extensionClassLoader;
    private final StatelessEngineConfiguration engineConfiguration;

    private StatelessBootstrap(ClassLoader engineClassLoader, ClassLoader extensionClassLoader, StatelessEngineConfiguration engineConfiguration) {
        this.engineClassLoader = engineClassLoader;
        this.extensionClassLoader = extensionClassLoader;
        this.engineConfiguration = engineConfiguration;
    }

    public StatelessDataflow createDataflow(DataflowDefinition dataflowDefinition) throws IOException, StatelessConfigurationException {
        StatelessDataflowFactory dataflowFactory = StatelessBootstrap.getSingleInstance(this.engineClassLoader, StatelessDataflowFactory.class);
        StatelessDataflow dataflow = dataflowFactory.createDataflow(this.engineConfiguration, dataflowDefinition, this.extensionClassLoader);
        return dataflow;
    }

    public DataflowDefinition parseDataflowDefinition(File flowDefinitionFile, List<ParameterOverride> parameterOverrides) throws StatelessConfigurationException, IOException {
        DataflowDefinitionParser dataflowDefinitionParser = StatelessBootstrap.getSingleInstance(this.engineClassLoader, DataflowDefinitionParser.class);
        DataflowDefinition dataflowDefinition = dataflowDefinitionParser.parseFlowDefinition(flowDefinitionFile, this.engineConfiguration, parameterOverrides);
        return dataflowDefinition;
    }

    public DataflowDefinition parseDataflowDefinition(Map<String, String> flowDefinitionProperties, List<ParameterOverride> parameterOverrides) throws StatelessConfigurationException, IOException {
        DataflowDefinitionParser dataflowDefinitionParser = StatelessBootstrap.getSingleInstance(this.engineClassLoader, DataflowDefinitionParser.class);
        DataflowDefinition dataflowDefinition = dataflowDefinitionParser.parseFlowDefinition(flowDefinitionProperties, this.engineConfiguration, parameterOverrides);
        return dataflowDefinition;
    }

    public static StatelessBootstrap bootstrap(StatelessEngineConfiguration engineConfiguration) throws IOException {
        return StatelessBootstrap.bootstrap(engineConfiguration, ClassLoader.getSystemClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StatelessBootstrap bootstrap(StatelessEngineConfiguration engineConfiguration, ClassLoader rootClassLoader) throws IOException {
        NarClassLoader engineClassLoader;
        File narDirectory = engineConfiguration.getNarDirectory();
        File workingDirectory = engineConfiguration.getWorkingDirectory();
        File narExpansionDirectory = new File(workingDirectory, "nar");
        if (!narExpansionDirectory.exists() && !narExpansionDirectory.mkdirs()) {
            throw new IOException("Working Directory " + String.valueOf(narExpansionDirectory) + " does not exist and could not be created");
        }
        Bundle systemBundle = SystemBundle.create((String)narDirectory.getAbsolutePath(), (ClassLoader)ClassLoader.getSystemClassLoader());
        File frameworkWorkingDir = new File(narExpansionDirectory, "framework");
        File extensionsWorkingDir = new File(narExpansionDirectory, "extensions");
        List<Path> narDirectories = Collections.singletonList(narDirectory.toPath());
        long unpackStart = System.currentTimeMillis();
        Predicate<BundleCoordinate> narFilter = coordinate -> true;
        NarUnpackLock.lock();
        try {
            NarUnpacker.unpackNars((Bundle)systemBundle, (File)frameworkWorkingDir, (File)extensionsWorkingDir, narDirectories, (boolean)false, (String)"nifi-framework-nar", (boolean)false, (boolean)false, (NarUnpackMode)NarUnpackMode.UNPACK_TO_UBER_JAR, narFilter);
        }
        finally {
            NarUnpackLock.unlock();
        }
        long unpackMillis = System.currentTimeMillis() - unpackStart;
        logger.info("Unpacked NAR files in {} millis", (Object)unpackMillis);
        AllowListClassLoader statelessClassLoader = StatelessBootstrap.createExtensionRootClassLoader(narDirectory, rootClassLoader);
        File statelessNarWorkingDir = StatelessBootstrap.locateStatelessNarWorkingDirectory(extensionsWorkingDir);
        try {
            engineClassLoader = new NarClassLoader(statelessNarWorkingDir, (ClassLoader)statelessClassLoader);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Could not create NarClassLoader for Stateless NAR located at " + statelessNarWorkingDir.getAbsolutePath(), e);
        }
        Thread.currentThread().setContextClassLoader((ClassLoader)engineClassLoader);
        return new StatelessBootstrap((ClassLoader)engineClassLoader, statelessClassLoader, engineConfiguration);
    }

    protected static AllowListClassLoader createExtensionRootClassLoader(File narDirectory, ClassLoader parent) throws IOException {
        File[] narDirectoryFiles = narDirectory.listFiles();
        if (narDirectoryFiles == null) {
            throw new IOException("Could not get a listing of the NAR directory");
        }
        logger.debug("NAR directory used to find files to allow being loaded by Stateless Extension Classloaders from parent {}: {}", (Object)parent, (Object)narDirectory);
        HashSet<String> classesAllowed = new HashSet<String>();
        HashSet<String> filesAllowed = new HashSet<String>();
        for (File file : narDirectoryFiles) {
            StatelessBootstrap.findClassNamesInJar(file, classesAllowed);
            filesAllowed.add(file.getName());
        }
        StatelessBootstrap.findClassNamesInDirectory(narDirectory, narDirectory, classesAllowed, filesAllowed);
        Set<File> javaHomeFiles = StatelessBootstrap.findJavaHomeFiles();
        HashSet<String> javaHomeFilenames = new HashSet<String>();
        for (File file : javaHomeFiles) {
            StatelessBootstrap.findLoadableClasses(file, classesAllowed);
            javaHomeFilenames.add(file.getName());
        }
        logger.debug("The following class/JAR files will be explicitly allowed to be loaded by Stateless Extensions ClassLoaders from parent {}: {}", (Object)parent, filesAllowed);
        logger.debug("The following JAR/JMOD files from ${JAVA_HOME} will be explicitly allowed to be loaded by Stateless Extensions ClassLoaders from parent {}: {}", (Object)parent, javaHomeFilenames);
        logger.debug("The final list of classes allowed to be loaded by Stateless Extension ClassLoaders from parent {}: {}", (Object)parent, classesAllowed);
        if (parent instanceof URLClassLoader) {
            URL[] parentUrls = ((URLClassLoader)parent).getURLs();
            logger.debug("Parent ClassLoader has the following URLs loaded: {}", Arrays.asList(parentUrls));
        } else {
            logger.debug("Parent ClassLoader is not a URLClassLoader: {} / {}", (Object)parent, parent.getClass());
        }
        AllowListClassLoader allowListClassLoader = new AllowListClassLoader(parent, classesAllowed);
        return allowListClassLoader;
    }

    private static Set<File> findJavaHomeFiles() {
        String javaHomeValue = System.getProperty("java.home");
        if (javaHomeValue == null) {
            logger.warn("Could not find java.home system property so will not allow any classes explicitly from java.home in AllowListClassLoader");
            return Collections.emptySet();
        }
        File javaHome = new File(javaHomeValue);
        if (!javaHome.exists()) {
            logger.warn("System property for java.home is {} but that directory does not exist so will not allow any classes explicitly from java.home in AllowListClassLoader", (Object)javaHomeValue);
            return Collections.emptySet();
        }
        logger.debug("Java Home Directory is {}", (Object)javaHome.getAbsolutePath());
        File[] javaHomeFiles = javaHome.listFiles();
        if (javaHomeFiles == null) {
            logger.warn("System property for java.home is {} but that directory is not readable so will not allow any classes explicitly from java.home in AllowListClassLoader", (Object)javaHomeValue);
            return Collections.emptySet();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Found the following files in Java Home: {}", Arrays.asList(javaHomeFiles));
            logger.debug("Full listing of Java Home:");
            StatelessBootstrap.logFullJavaHomeListing(javaHomeFiles);
        }
        HashSet<File> loadableFiles = new HashSet<File>();
        for (File file : javaHomeFiles) {
            StatelessBootstrap.findLoadableFiles(file, loadableFiles);
        }
        return loadableFiles;
    }

    private static void logFullJavaHomeListing(File[] files) {
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                logger.debug("{}/", (Object)file.getAbsolutePath());
                File[] children = file.listFiles();
                if (children == null) {
                    logger.debug("Failed to perform listing of directory {}", (Object)file);
                    continue;
                }
                StatelessBootstrap.logFullJavaHomeListing(children);
                continue;
            }
            logger.debug(file.getAbsolutePath());
        }
    }

    private static void findLoadableFiles(File file, Set<File> loadable) {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            if (children == null) {
                logger.debug("Unable to obtain listing of files for directory {}", (Object)file.getAbsolutePath());
                return;
            }
            for (File child : children) {
                StatelessBootstrap.findLoadableFiles(child, loadable);
            }
            return;
        }
        String filename = file.getName();
        if (filename.endsWith(".jar")) {
            loadable.add(file);
        }
    }

    private static void findLoadableClasses(File file, Set<String> classNames) throws IOException {
        String filename = file.getName();
        if (filename.endsWith(".jar")) {
            StatelessBootstrap.findClassNamesInJar(file, classNames);
        }
    }

    private static void findClassNamesInJar(File file, Set<String> classNames) throws IOException {
        if (!(file.getName().endsWith(".jar") && file.isFile() && file.exists())) {
            return;
        }
        try (JarFile jarFile = new JarFile(file);){
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String entryName = zipEntry.getName();
                if (!entryName.endsWith(".class")) continue;
                int lastIndex = entryName.lastIndexOf(".class");
                String className = entryName.substring(0, lastIndex).replace("/", ".");
                classNames.add(className);
            }
        }
    }

    static void findClassNamesInDirectory(File file, File baseDirectory, Set<String> classNames, Set<String> fileNames) {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            if (children != null) {
                for (File child : children) {
                    StatelessBootstrap.findClassNamesInDirectory(child, baseDirectory, classNames, fileNames);
                }
            }
            return;
        }
        String filename = file.getName();
        if (filename.endsWith(".class")) {
            String baseDirectoryPath;
            String absolutePath = file.getAbsolutePath();
            if (!absolutePath.startsWith(baseDirectoryPath = baseDirectory.getAbsolutePath())) {
                return;
            }
            File relativeFile = baseDirectory.toPath().relativize(file.toPath()).toFile();
            String relativePath = relativeFile.getPath();
            int lastIndex = relativePath.lastIndexOf(".class");
            String className = relativePath.substring(0, lastIndex).replace(File.separator, ".");
            classNames.add(className);
            fileNames.add(filename);
        }
    }

    private static File locateStatelessNarWorkingDirectory(File workingDirectory) throws IOException {
        File[] files = workingDirectory.listFiles();
        if (files == null) {
            throw new IOException("Could not read contents of working directory " + String.valueOf(workingDirectory));
        }
        ArrayList<File> matching = new ArrayList<File>();
        for (File file : files) {
            String filename = file.getName();
            if (!STATELESS_NAR_PATTERN.matcher(filename).matches()) continue;
            matching.add(file);
        }
        if (matching.isEmpty()) {
            throw new IOException("Could not find NiFi Stateless NAR in working directory " + String.valueOf(workingDirectory));
        }
        if (matching.size() > 1) {
            throw new IOException("Found multiple NiFi Stateless NARs in working directory " + String.valueOf(workingDirectory) + ": " + String.valueOf(matching));
        }
        return (File)matching.get(0);
    }

    private static <T> T getSingleInstance(ClassLoader classLoader, Class<T> type) {
        ServiceLoader<T> serviceLoader = ServiceLoader.load(type, classLoader);
        T instance = null;
        for (T object : serviceLoader) {
            if (instance == null) {
                instance = object;
                continue;
            }
            throw new IllegalStateException("Found multiple implementations of " + String.valueOf(type));
        }
        if (instance == null) {
            throw new IllegalStateException("Could not find any implementations of " + String.valueOf(type));
        }
        return instance;
    }
}

