/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit;

import java.util.HashSet;
import java.util.Set;
import org.openqa.selenium.Keys;

class KeyboardModifiersState {
    private Set<Character> set_ = new HashSet<Character>();
    private boolean shiftPressed_;
    private boolean ctrlPressed_;
    private boolean altPressed_;

    KeyboardModifiersState() {
    }

    public boolean isShiftPressed() {
        return this.shiftPressed_;
    }

    public boolean isCtrlPressed() {
        return this.ctrlPressed_;
    }

    public boolean isAltPressed() {
        return this.altPressed_;
    }

    public void storeKeyDown(char key) {
        this.storeIfEqualsShift(key, true);
        this.storeIfEqualsCtrl(key, true);
        this.storeIfEqualsAlt(key, true);
        this.set_.add(Character.valueOf(key));
    }

    public void storeKeyUp(char key) {
        this.storeIfEqualsShift(key, false);
        this.storeIfEqualsCtrl(key, false);
        this.storeIfEqualsAlt(key, false);
        this.set_.remove(Character.valueOf(key));
    }

    private void storeIfEqualsShift(char key, boolean keyState) {
        if (key == Keys.SHIFT.charAt(0)) {
            this.shiftPressed_ = keyState;
        }
    }

    private void storeIfEqualsCtrl(char key, boolean keyState) {
        if (key == Keys.CONTROL.charAt(0)) {
            this.ctrlPressed_ = keyState;
        }
    }

    private void storeIfEqualsAlt(char key, boolean keyState) {
        if (key == Keys.ALT.charAt(0)) {
            this.altPressed_ = keyState;
        }
    }

    boolean isPressed(Keys keys) {
        return this.isPressed(keys.charAt(0));
    }

    boolean isPressed(char ch) {
        return this.set_.contains(Character.valueOf(ch));
    }
}

