/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import java.text.NumberFormat;
import java.util.IllformedLocaleException;
import java.util.Locale;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;

public final class NumberCustom {
    private NumberCustom() {
    }

    public static String toLocaleString(Context context, Scriptable thisObj, Object[] args, Function function) {
        if (args.length != 0 && args[0] instanceof String) {
            String localeStr = (String)args[0];
            try {
                Locale locale = new Locale.Builder().setLanguageTag(localeStr).build();
                return NumberFormat.getInstance(locale).format(Double.parseDouble(thisObj.toString()));
            }
            catch (IllformedLocaleException e) {
                throw ScriptRuntime.rangeError((String)("Invalid language tag: " + localeStr));
            }
        }
        BrowserVersion browserVersion = ((Window)thisObj.getParentScope()).getBrowserVersion();
        Locale locale = Locale.forLanguageTag(browserVersion.getBrowserLanguage());
        return NumberFormat.getInstance(locale).format(Double.parseDouble(thisObj.toString()));
    }
}

