/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.lexer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import org.htmlparser.lexer.Source;
import org.htmlparser.lexer.Stream;
import org.htmlparser.util.EncodingChangeException;
import org.htmlparser.util.ParserException;

public class InputStreamSource
extends Source {
    public static final int BUFFER_SIZE = 16384;
    protected transient InputStream mStream;
    protected String mEncoding;
    protected transient InputStreamReader mReader;
    protected char[] mBuffer;
    protected int mLevel;
    protected int mOffset;
    protected int mMark;

    public InputStreamSource(InputStream stream) throws UnsupportedEncodingException {
        this(stream, null, 16384);
    }

    public InputStreamSource(InputStream stream, String charset) throws UnsupportedEncodingException {
        this(stream, charset, 16384);
    }

    public InputStreamSource(InputStream stream, String charset, int size) throws UnsupportedEncodingException {
        if (null == stream) {
            stream = new Stream(null);
        } else if (!stream.markSupported()) {
            stream = new Stream(stream);
        }
        this.mStream = stream;
        if (null == charset) {
            this.mReader = new InputStreamReader(stream);
            this.mEncoding = this.mReader.getEncoding();
        } else {
            this.mEncoding = charset;
            this.mReader = new InputStreamReader(stream, charset);
        }
        this.mBuffer = new char[size];
        this.mLevel = 0;
        this.mOffset = 0;
        this.mMark = -1;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (null != this.mStream) {
            int offset = this.mOffset;
            char[] buffer = new char[4096];
            while (-1 != this.read(buffer)) {
            }
            this.mOffset = offset;
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (null != this.mBuffer) {
            this.mStream = new ByteArrayInputStream(new byte[0]);
        }
    }

    public InputStream getStream() {
        return this.mStream;
    }

    public String getEncoding() {
        return this.mEncoding;
    }

    public void setEncoding(String character_set) throws ParserException {
        String encoding = this.getEncoding();
        if (!encoding.equalsIgnoreCase(character_set)) {
            InputStream stream = this.getStream();
            try {
                char[] buffer = this.mBuffer;
                int offset = this.mOffset;
                stream.reset();
                try {
                    this.mEncoding = character_set;
                    this.mReader = new InputStreamReader(stream, character_set);
                    this.mBuffer = new char[this.mBuffer.length];
                    this.mLevel = 0;
                    this.mOffset = 0;
                    this.mMark = -1;
                    if (0 != offset) {
                        char[] new_chars = new char[offset];
                        if (offset != this.read(new_chars)) {
                            throw new ParserException("reset stream failed");
                        }
                        for (int i = 0; i < offset; ++i) {
                            if (new_chars[i] == buffer[i]) continue;
                            throw new EncodingChangeException("character mismatch (new: " + new_chars[i] + " [0x" + Integer.toString(new_chars[i], 16) + "] != old: " + " [0x" + Integer.toString(buffer[i], 16) + buffer[i] + "]) for encoding change from " + encoding + " to " + character_set + " at character offset " + i, encoding, character_set);
                        }
                    }
                }
                catch (IOException ioe) {
                    throw new ParserException(ioe.getMessage(), ioe);
                }
            }
            catch (IOException ioe) {
                throw new ParserException("Stream reset failed (" + ioe.getMessage() + "), try wrapping it with a org.htmlparser.lexer.Stream", ioe);
            }
        }
    }

    protected void fill(int min) throws IOException {
        if (null != this.mReader) {
            char[] buffer;
            int read;
            int size = this.mBuffer.length - this.mLevel;
            if (size < min) {
                size = this.mBuffer.length * 2;
                read = this.mLevel + min;
                if (size < read) {
                    size = read;
                } else {
                    min = size - this.mLevel;
                }
                buffer = new char[size];
            } else {
                buffer = this.mBuffer;
                min = size;
            }
            read = this.mReader.read(buffer, this.mLevel, min);
            if (-1 == read) {
                this.mReader.close();
                this.mReader = null;
            } else {
                if (this.mBuffer != buffer) {
                    System.arraycopy(this.mBuffer, 0, buffer, 0, this.mLevel);
                    this.mBuffer = buffer;
                }
                this.mLevel += read;
            }
        }
    }

    public void close() throws IOException {
    }

    public int read() throws IOException {
        int ret;
        if (this.mLevel - this.mOffset < 1) {
            if (null == this.mStream) {
                throw new IOException("source is closed");
            }
            this.fill(1);
            ret = this.mOffset >= this.mLevel ? -1 : this.mBuffer[this.mOffset++];
        } else {
            ret = this.mBuffer[this.mOffset++];
        }
        return ret;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int ret;
        if (null == this.mStream) {
            throw new IOException("source is closed");
        }
        if (null == cbuf || 0 > off || 0 > len) {
            throw new IOException("illegal argument read (" + (null == cbuf ? "null" : "cbuf") + ", " + off + ", " + len + ")");
        }
        if (this.mLevel - this.mOffset < len) {
            this.fill(len - (this.mLevel - this.mOffset));
        }
        if (this.mOffset >= this.mLevel) {
            ret = -1;
        } else {
            ret = Math.min(this.mLevel - this.mOffset, len);
            System.arraycopy(this.mBuffer, this.mOffset, cbuf, off, ret);
            this.mOffset += ret;
        }
        return ret;
    }

    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    public void reset() throws IllegalStateException {
        if (null == this.mStream) {
            throw new IllegalStateException("source is closed");
        }
        this.mOffset = -1 != this.mMark ? this.mMark : 0;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int readAheadLimit) throws IOException {
        if (null == this.mStream) {
            throw new IOException("source is closed");
        }
        this.mMark = this.mOffset;
    }

    public boolean ready() throws IOException {
        if (null == this.mStream) {
            throw new IOException("source is closed");
        }
        return this.mOffset < this.mLevel;
    }

    public long skip(long n) throws IOException, IllegalArgumentException {
        long ret;
        if (null == this.mStream) {
            throw new IOException("source is closed");
        }
        if (0L > n) {
            throw new IllegalArgumentException("cannot skip backwards");
        }
        if ((long)(this.mLevel - this.mOffset) < n) {
            this.fill((int)(n - (long)(this.mLevel - this.mOffset)));
        }
        if (this.mOffset >= this.mLevel) {
            ret = -1L;
        } else {
            ret = Math.min((long)(this.mLevel - this.mOffset), n);
            this.mOffset = (int)((long)this.mOffset + ret);
        }
        return ret;
    }

    public void unread() throws IOException {
        if (null == this.mStream) {
            throw new IOException("source is closed");
        }
        if (0 < this.mOffset) {
            --this.mOffset;
        } else {
            throw new IOException("can't unread no characters");
        }
    }

    public char getCharacter(int offset) throws IOException {
        if (null == this.mStream) {
            throw new IOException("source is closed");
        }
        if (offset >= this.mBuffer.length) {
            throw new IOException("illegal read ahead");
        }
        char ret = this.mBuffer[offset];
        return ret;
    }

    public void getCharacters(char[] array, int offset, int start, int end) throws IOException {
        if (null == this.mStream) {
            throw new IOException("source is closed");
        }
        System.arraycopy(this.mBuffer, start, array, offset, end - start);
    }

    public String getString(int offset, int length) throws IOException {
        if (null == this.mStream) {
            throw new IOException("source is closed");
        }
        if (offset + length > this.mBuffer.length) {
            throw new IOException("illegal read ahead");
        }
        String ret = new String(this.mBuffer, offset, length);
        return ret;
    }

    public void getCharacters(StringBuffer buffer, int offset, int length) throws IOException {
        if (null == this.mStream) {
            throw new IOException("source is closed");
        }
        buffer.append(this.mBuffer, offset, length);
    }

    public void destroy() throws IOException {
        this.mStream = null;
        if (null != this.mReader) {
            this.mReader.close();
        }
        this.mReader = null;
        this.mBuffer = null;
        this.mLevel = 0;
        this.mOffset = 0;
        this.mMark = -1;
    }

    public int offset() {
        int ret = null == this.mStream ? -1 : this.mOffset;
        return ret;
    }

    public int available() {
        int ret = null == this.mStream ? 0 : this.mLevel - this.mOffset;
        return ret;
    }
}

