/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.Objects;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;

public class Rectangle {
    public final int x;
    public final int y;
    public final int height;
    public final int width;

    public Rectangle(int x, int y, int height, int width) {
        this.x = x;
        this.y = y;
        this.height = height;
        this.width = width;
    }

    public Rectangle(Point p, Dimension d) {
        this.x = p.x;
        this.y = p.y;
        this.height = d.height;
        this.width = d.width;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public Point getPoint() {
        return new Point(this.x, this.y);
    }

    public Dimension getDimension() {
        return new Dimension(this.width, this.height);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rectangle rectangle = (Rectangle)o;
        return this.x == rectangle.x && this.y == rectangle.y && this.height == rectangle.height && this.width == rectangle.width;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.height, this.width);
    }
}

