/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.upgrade.get;

import java.io.IOException;
import org.opensearch.action.support.broadcast.BroadcastShardResponse;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;

public class ShardUpgradeStatus
extends BroadcastShardResponse {
    private ShardRouting shardRouting;
    private long totalBytes;
    private long toUpgradeBytes;
    private long toUpgradeBytesAncient;

    public ShardUpgradeStatus(StreamInput in) throws IOException {
        super(in);
        this.shardRouting = new ShardRouting(in);
        this.totalBytes = in.readLong();
        this.toUpgradeBytes = in.readLong();
        this.toUpgradeBytesAncient = in.readLong();
    }

    ShardUpgradeStatus(ShardRouting shardRouting, long totalBytes, long toUpgradeBytes, long upgradeBytesAncient) {
        super(shardRouting.shardId());
        this.shardRouting = shardRouting;
        this.totalBytes = totalBytes;
        this.toUpgradeBytes = toUpgradeBytes;
        this.toUpgradeBytesAncient = upgradeBytesAncient;
    }

    public ShardRouting getShardRouting() {
        return this.shardRouting;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public long getToUpgradeBytes() {
        return this.toUpgradeBytes;
    }

    public long getToUpgradeBytesAncient() {
        return this.toUpgradeBytesAncient;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.shardRouting.writeTo(out);
        out.writeLong(this.totalBytes);
        out.writeLong(this.toUpgradeBytes);
        out.writeLong(this.toUpgradeBytesAncient);
    }
}

