/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.response;

import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Cluster {
    private List<String> labels;
    private double score;
    private List<String> docIds;
    private List<Cluster> subclusters;
    private boolean otherTopics;

    public Cluster(List<String> labels, double score, List<String> docIds) {
        this(labels, score, docIds, Collections.emptyList(), false);
    }

    public Cluster(List<String> labels, double score, List<String> docIds, List<Cluster> subclusters, boolean otherTopics) {
        this.labels = labels;
        this.score = score;
        this.docIds = docIds;
        this.subclusters = subclusters;
        this.otherTopics = otherTopics;
    }

    public boolean equals(Object o) {
        return o != null && this.getClass().isInstance(o) && this.equalsTo((Cluster)o);
    }

    private boolean equalsTo(Cluster o) {
        return Double.compare(o.score, this.score) == 0 && Objects.equals(o.docIds, this.docIds) && Objects.equals(o.labels, this.labels) && Objects.equals(o.subclusters, this.subclusters);
    }

    public int hashCode() {
        return Objects.hash(this.subclusters, this.docIds, this.labels, this.score);
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public double getScore() {
        return this.score;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public List<String> getDocs() {
        return this.docIds;
    }

    public void setDocs(List<String> docIds) {
        this.docIds = docIds;
    }

    public List<Cluster> getSubclusters() {
        return this.subclusters;
    }

    public boolean isOtherTopics() {
        return this.otherTopics;
    }
}

