/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableAggregate is an enum
type OpcuaNodeIdServicesVariableAggregate int32

type IOpcuaNodeIdServicesVariableAggregate interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableAggregate_AggregateConfigurationType_TreatUncertainAsBad    OpcuaNodeIdServicesVariableAggregate = 11188
	OpcuaNodeIdServicesVariableAggregate_AggregateConfigurationType_PercentDataBad         OpcuaNodeIdServicesVariableAggregate = 11189
	OpcuaNodeIdServicesVariableAggregate_AggregateConfigurationType_PercentDataGood        OpcuaNodeIdServicesVariableAggregate = 11190
	OpcuaNodeIdServicesVariableAggregate_AggregateConfigurationType_UseSlopedExtrapolation OpcuaNodeIdServicesVariableAggregate = 11191
)

var OpcuaNodeIdServicesVariableAggregateValues []OpcuaNodeIdServicesVariableAggregate

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableAggregateValues = []OpcuaNodeIdServicesVariableAggregate{
		OpcuaNodeIdServicesVariableAggregate_AggregateConfigurationType_TreatUncertainAsBad,
		OpcuaNodeIdServicesVariableAggregate_AggregateConfigurationType_PercentDataBad,
		OpcuaNodeIdServicesVariableAggregate_AggregateConfigurationType_PercentDataGood,
		OpcuaNodeIdServicesVariableAggregate_AggregateConfigurationType_UseSlopedExtrapolation,
	}
}

func OpcuaNodeIdServicesVariableAggregateByValue(value int32) (enum OpcuaNodeIdServicesVariableAggregate, ok bool) {
	switch value {
	case 11188:
		return OpcuaNodeIdServicesVariableAggregate_AggregateConfigurationType_TreatUncertainAsBad, true
	case 11189:
		return OpcuaNodeIdServicesVariableAggregate_AggregateConfigurationType_PercentDataBad, true
	case 11190:
		return OpcuaNodeIdServicesVariableAggregate_AggregateConfigurationType_PercentDataGood, true
	case 11191:
		return OpcuaNodeIdServicesVariableAggregate_AggregateConfigurationType_UseSlopedExtrapolation, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableAggregateByName(value string) (enum OpcuaNodeIdServicesVariableAggregate, ok bool) {
	switch value {
	case "AggregateConfigurationType_TreatUncertainAsBad":
		return OpcuaNodeIdServicesVariableAggregate_AggregateConfigurationType_TreatUncertainAsBad, true
	case "AggregateConfigurationType_PercentDataBad":
		return OpcuaNodeIdServicesVariableAggregate_AggregateConfigurationType_PercentDataBad, true
	case "AggregateConfigurationType_PercentDataGood":
		return OpcuaNodeIdServicesVariableAggregate_AggregateConfigurationType_PercentDataGood, true
	case "AggregateConfigurationType_UseSlopedExtrapolation":
		return OpcuaNodeIdServicesVariableAggregate_AggregateConfigurationType_UseSlopedExtrapolation, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableAggregateKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableAggregateValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableAggregate(structType any) OpcuaNodeIdServicesVariableAggregate {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableAggregate {
		if sOpcuaNodeIdServicesVariableAggregate, ok := typ.(OpcuaNodeIdServicesVariableAggregate); ok {
			return sOpcuaNodeIdServicesVariableAggregate
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableAggregate) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableAggregate) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableAggregateParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableAggregate, error) {
	return OpcuaNodeIdServicesVariableAggregateParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableAggregateParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableAggregate, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("OpcuaNodeIdServicesVariableAggregate", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableAggregate")
	}
	if enum, ok := OpcuaNodeIdServicesVariableAggregateByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableAggregate")
		return OpcuaNodeIdServicesVariableAggregate(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableAggregate) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableAggregate) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableAggregate", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e OpcuaNodeIdServicesVariableAggregate) GetValue() int32 {
	return int32(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableAggregate) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableAggregate_AggregateConfigurationType_TreatUncertainAsBad:
		return "AggregateConfigurationType_TreatUncertainAsBad"
	case OpcuaNodeIdServicesVariableAggregate_AggregateConfigurationType_PercentDataBad:
		return "AggregateConfigurationType_PercentDataBad"
	case OpcuaNodeIdServicesVariableAggregate_AggregateConfigurationType_PercentDataGood:
		return "AggregateConfigurationType_PercentDataGood"
	case OpcuaNodeIdServicesVariableAggregate_AggregateConfigurationType_UseSlopedExtrapolation:
		return "AggregateConfigurationType_UseSlopedExtrapolation"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableAggregate) String() string {
	return e.PLC4XEnumName()
}
