/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.transport;

import org.apache.qpid.server.QpidException;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v0_8.AMQShortString;
import org.apache.qpid.server.protocol.v0_8.transport.AMQMethodBody;
import org.apache.qpid.server.protocol.v0_8.transport.AMQMethodBodyImpl;
import org.apache.qpid.server.protocol.v0_8.transport.ClientChannelMethodProcessor;
import org.apache.qpid.server.protocol.v0_8.transport.EncodableAMQDataBlock;
import org.apache.qpid.server.protocol.v0_8.transport.MethodDispatcher;

public class BasicCancelOkBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 60;
    public static final int METHOD_ID = 31;
    private final AMQShortString _consumerTag;

    public BasicCancelOkBody(AMQShortString consumerTag) {
        this._consumerTag = consumerTag;
    }

    @Override
    public int getClazz() {
        return 60;
    }

    @Override
    public int getMethod() {
        return 31;
    }

    public final AMQShortString getConsumerTag() {
        return this._consumerTag;
    }

    @Override
    protected int getBodySize() {
        int size = 0;
        return size += this.getSizeOf(this._consumerTag);
    }

    @Override
    public void writeMethodPayload(QpidByteBuffer buffer) {
        this.writeAMQShortString(buffer, this._consumerTag);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchBasicCancelOk(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[BasicCancelOkBodyImpl: ");
        buf.append("consumerTag=");
        buf.append(this.getConsumerTag());
        buf.append("]");
        return buf.toString();
    }

    public static void process(QpidByteBuffer in, ClientChannelMethodProcessor dispatcher) {
        AMQShortString consumerTag = AMQShortString.readAMQShortString(in);
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveBasicCancelOk(consumerTag);
        }
    }
}

