/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.config;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.apache.qpid.server.logging.EventLoggerProvider;
import org.apache.qpid.server.security.Result;
import org.apache.qpid.server.security.access.config.LegacyOperation;
import org.apache.qpid.server.security.access.config.ObjectType;
import org.apache.qpid.server.security.access.config.Rule;
import org.apache.qpid.server.security.access.config.RuleInspector;
import org.apache.qpid.server.security.access.config.RuleSet;
import org.apache.qpid.server.security.access.config.RuleSetImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RuleSetBuilder
extends AbstractList<Rule>
implements RuleSet.Builder {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuleSetBuilder.class);
    private final Map<LegacyOperation, Map<ObjectType, List<Rule>>> _ruleMap = new EnumMap<LegacyOperation, Map<ObjectType, List<Rule>>>(LegacyOperation.class);
    private final List<Rule> _ruleList = new ArrayList<Rule>();
    private final EventLoggerProvider _eventLogger;
    private RuleSetImpl.DefaultResultInspector _defaultInspector = new RuleSetImpl.DefaultResultInspector(Result.DENIED);

    RuleSetBuilder(EventLoggerProvider eventLogger) {
        this._eventLogger = eventLogger;
    }

    @Override
    public RuleSet.Builder setDefaultResult(Result result) {
        this._defaultInspector = new RuleSetImpl.DefaultResultInspector(result);
        return this;
    }

    @Override
    public RuleSet.Builder addAllRules(Collection<? extends Rule> rules) {
        this.addAll(rules);
        return this;
    }

    @Override
    public RuleSet build() {
        return new RuleSetImpl(this);
    }

    @Override
    public Rule get(int index) {
        return this._ruleList.get(index);
    }

    @Override
    public int size() {
        return this._ruleList.size();
    }

    @Override
    public boolean add(Rule rule) {
        if (this.validate(rule)) {
            this.addRuleToOperationMap(rule);
            return this._ruleList.add(rule);
        }
        return false;
    }

    private boolean validate(Rule rule) {
        if (rule.getOperation() == LegacyOperation.CREATE && rule.isForOwner()) {
            LOGGER.warn("Invalid rule with create operation for owner '{}'", (Object)rule);
            return false;
        }
        return true;
    }

    EventLoggerProvider getEventLogger() {
        return this._eventLogger;
    }

    RuleSetImpl.DefaultResultInspector getDefaultInspector() {
        return this._defaultInspector;
    }

    Map<LegacyOperation, Map<ObjectType, RuleInspector>> buildCache() {
        EnumMap operationMap = new EnumMap(LegacyOperation.class);
        for (LegacyOperation operation : LegacyOperation.values()) {
            EnumMap<ObjectType, RuleInspector> objectMap = new EnumMap<ObjectType, RuleInspector>(ObjectType.class);
            for (ObjectType object : ObjectType.values()) {
                List<Rule> rules = this.groupBy(operation, object);
                objectMap.put(object, this.convertToInspector(rules));
            }
            operationMap.put(operation, Collections.unmodifiableMap(objectMap));
        }
        return Collections.unmodifiableMap(operationMap);
    }

    private RuleInspector convertToInspector(List<? extends Rule> rules) {
        if (rules.isEmpty()) {
            return this._defaultInspector;
        }
        if (rules.stream().anyMatch(Rule::isForOwner)) {
            return this.newInspector(RuleSetImpl.RuleBasedInspectorWithOwnerFilteringFactory.newInstance(rules, this._eventLogger));
        }
        return this.newInspector(RuleSetImpl.RuleBasedInspectorFactory.newInstance(rules, this._eventLogger));
    }

    private RuleInspector newInspector(RuleInspector.RuleInspectorFactory factory) {
        if (factory.isConstant()) {
            return factory.newInspector(Collections.emptySet());
        }
        return new RuleSetImpl.CachedInspector(factory).init();
    }

    private List<Rule> groupBy(LegacyOperation operation, ObjectType objectType) {
        return Collections.unmodifiableList(this._ruleMap.getOrDefault((Object)operation, Collections.emptyMap()).getOrDefault((Object)objectType, Collections.emptyList()));
    }

    private void addRuleToOperationMap(Rule rule) {
        if (LegacyOperation.ALL == rule.getOperation()) {
            for (LegacyOperation operation : LegacyOperation.values()) {
                this.addRuleToObjectTypeMap(this._ruleMap.computeIfAbsent(operation, opera -> new EnumMap(ObjectType.class)), rule);
            }
        } else {
            this.addRuleToObjectTypeMap(this._ruleMap.computeIfAbsent(rule.getOperation(), opera -> new EnumMap(ObjectType.class)), rule);
        }
    }

    private void addRuleToObjectTypeMap(Map<ObjectType, List<Rule>> objectTypeMap, Rule rule) {
        if (ObjectType.ALL == rule.getObjectType()) {
            for (ObjectType object : ObjectType.values()) {
                objectTypeMap.computeIfAbsent(object, obj -> new ArrayList()).add(rule);
            }
        } else {
            objectTypeMap.computeIfAbsent(rule.getObjectType(), obj -> new ArrayList()).add(rule);
        }
    }
}

