/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.shardingsphere.infra.binder.engine.segment.dml.predicate;

import com.cedarsoftware.util.CaseInsensitiveMap.CaseInsensitiveString;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.context.TableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.HavingSegment;
import org.junit.jupiter.api.Test;

import static org.hamcrest.Matchers.is;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.mockito.Mockito.mock;

class HavingSegmentBinderTest {
    
    @Test
    void assertBind() {
        SQLStatementBinderContext sqlStatementBinderContext = mock(SQLStatementBinderContext.class);
        HavingSegment expectedHavingSegment = new HavingSegment(1, 2, mock(ExpressionSegment.class));
        Multimap<CaseInsensitiveString, TableSegmentBinderContext> currentTableBinderContexts = LinkedHashMultimap.create();
        Multimap<CaseInsensitiveString, TableSegmentBinderContext> tableBinderContexts = LinkedHashMultimap.create();
        Multimap<CaseInsensitiveString, TableSegmentBinderContext> outerTableBinderContexts = LinkedHashMultimap.create();
        HavingSegment actualHavingSegment = HavingSegmentBinder.bind(expectedHavingSegment, sqlStatementBinderContext, currentTableBinderContexts, tableBinderContexts, outerTableBinderContexts);
        assertThat(actualHavingSegment.getStopIndex(), is(expectedHavingSegment.getStopIndex()));
        assertThat(actualHavingSegment.getStartIndex(), is(expectedHavingSegment.getStartIndex()));
        assertThat(actualHavingSegment.getExpr(), is(expectedHavingSegment.getExpr()));
    }
}
