/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.shardingsphere.data.pipeline.core.preparer.inventory.calculator.position.exact;

import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.query.Range;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.type.pk.UniqueKeyIngestPosition;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * Integer position handler.
 */
public final class IntegerPositionHandler implements DataTypePositionHandler<BigInteger> {
    
    @Override
    public BigInteger readColumnValue(final ResultSet resultSet, final int columnIndex) throws SQLException {
        BigDecimal decimal = resultSet.getBigDecimal(columnIndex);
        return null == decimal ? null : decimal.toBigInteger();
    }
    
    @Override
    public void setPreparedStatementValue(final PreparedStatement preparedStatement, final int parameterIndex, final BigInteger value) throws SQLException {
        preparedStatement.setBigDecimal(parameterIndex, new BigDecimal(value));
    }
    
    @Override
    public UniqueKeyIngestPosition<BigInteger> createIngestPosition(final Range<BigInteger> range) {
        return UniqueKeyIngestPosition.ofInteger(range);
    }
}
