/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.shardingsphere.test.it.sql.parser.internal.asserts.statement.dal.dialect.doris.type;

import lombok.AccessLevel;
import lombok.NoArgsConstructor;
import org.apache.shardingsphere.sql.parser.statement.doris.dal.show.DorisShowQueryStatsStatement;
import org.apache.shardingsphere.test.it.sql.parser.internal.asserts.SQLCaseAssertContext;
import org.apache.shardingsphere.test.it.sql.parser.internal.asserts.segment.SQLSegmentAssert;
import org.apache.shardingsphere.test.it.sql.parser.internal.asserts.segment.database.DatabaseAssert;
import org.apache.shardingsphere.test.it.sql.parser.internal.asserts.segment.table.TableAssert;
import org.apache.shardingsphere.test.it.sql.parser.internal.cases.parser.jaxb.statement.dal.dialect.doris.show.DorisShowQueryStatsStatementTestCase;

import static org.hamcrest.Matchers.is;
import static org.hamcrest.MatcherAssert.assertThat;

/**
 * Show query stats statement assert for Doris.
 */
@NoArgsConstructor(access = AccessLevel.PRIVATE)
public final class DorisShowQueryStatsStatementAssert {
    
    /**
     * Assert show query stats statement is correct with expected parser result.
     *
     * @param assertContext assert context
     * @param actual actual show query stats statement
     * @param expected expected show query stats statement test case
     */
    public static void assertIs(final SQLCaseAssertContext assertContext, final DorisShowQueryStatsStatement actual, final DorisShowQueryStatsStatementTestCase expected) {
        if (null != expected.getDatabase()) {
            DatabaseAssert.assertIs(assertContext, actual.getDatabase().orElse(null), expected.getDatabase());
        }
        assertFromTable(assertContext, actual, expected);
        assertThat(assertContext.getText("Assertion error: all flag does not match."), actual.isAll(), is(expected.isAll()));
        assertThat(assertContext.getText("Assertion error: verbose flag does not match."), actual.isVerbose(), is(expected.isVerbose()));
    }
    
    private static void assertFromTable(final SQLCaseAssertContext assertContext, final DorisShowQueryStatsStatement actual, final DorisShowQueryStatsStatementTestCase expected) {
        if (null == expected.getFrom() || !actual.getFromTable().isPresent()) {
            return;
        }
        SQLSegmentAssert.assertIs(assertContext, actual.getFromTable().get(), expected.getFrom());
        if (null != expected.getFrom().getTable()) {
            TableAssert.assertIs(assertContext, actual.getTable().orElse(null), expected.getFrom().getTable());
        }
    }
}
