/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform2D;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

final class TransformAdapter2D
extends AbstractMathTransform2D
implements Serializable {
    private static final long serialVersionUID = 7587206692912120654L;
    private final MathTransform impl;

    TransformAdapter2D(MathTransform impl) {
        this.impl = impl;
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
        Matrix d;
        Matrix matrix = d = derivate ? this.impl.derivative((DirectPosition)new DirectPosition2D(srcPts[srcOff], srcPts[srcOff + 1])) : null;
        if (dstPts != null) {
            this.impl.transform(srcPts, srcOff, dstPts, dstOff, 1);
        }
        return d;
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        this.impl.transform(srcPts, srcOff, dstPts, dstOff, numPts);
    }

    @Override
    public void transform(double[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        this.impl.transform(srcPts, srcOff, dstPts, dstOff, numPts);
    }

    @Override
    public void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        this.impl.transform(srcPts, srcOff, dstPts, dstOff, numPts);
    }

    @Override
    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        this.impl.transform(srcPts, srcOff, dstPts, dstOff, numPts);
    }

    @Override
    public DirectPosition transform(DirectPosition ptSrc, DirectPosition ptDst) throws TransformException {
        return this.impl.transform(ptSrc, ptDst);
    }

    @Override
    public MathTransform2D inverse() throws NoninvertibleTransformException {
        return MathTransforms.bidimensional(this.impl.inverse());
    }

    @Override
    public String toWKT() {
        return this.impl.toWKT();
    }
}

