/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql.feature;

import java.sql.Connection;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.internal.shared.FeatureProjection;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Filter;
import org.apache.sis.filter.Optimization;
import org.apache.sis.metadata.sql.internal.shared.SQLBuilder;
import org.apache.sis.pending.geoapi.filter.SortBy;
import org.apache.sis.storage.base.SortByComparator;
import org.apache.sis.storage.sql.feature.Column;
import org.apache.sis.storage.sql.feature.ComputedColumn;
import org.apache.sis.storage.sql.feature.Database;
import org.apache.sis.storage.sql.feature.FeatureIterator;
import org.apache.sis.storage.sql.feature.InfoStatements;
import org.apache.sis.storage.sql.feature.SelectionClause;
import org.apache.sis.storage.sql.feature.SelectionClauseWriter;
import org.apache.sis.storage.sql.feature.Table;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.stream.DeferredStream;
import org.apache.sis.util.stream.PaginedStream;

final class FeatureStream
extends DeferredStream<AbstractFeature> {
    private final Table table;
    private FeatureProjection projection;
    private SelectionClauseWriter filterToSQL;
    private SelectionClause selection;
    private boolean hasPredicates;
    private boolean hasComparator;
    private boolean distinct;
    private SortBy<? super AbstractFeature> sort;
    private long offset;
    private long count;

    FeatureStream(Table table, boolean parallel) {
        super(256, parallel);
        this.listener = table.database.createFilterListener();
        this.table = table;
    }

    @Override
    private Stream<AbstractFeature> empty() {
        this.count = 0L;
        this.delegate();
        return Stream.empty();
    }

    private boolean isPagined() {
        return (this.offset | this.count) != 0L;
    }

    @Override
    public Stream<AbstractFeature> filter(Predicate<? super AbstractFeature> predicate) {
        Objects.requireNonNull(predicate);
        if (predicate == Filter.include()) {
            return this;
        }
        if (predicate == Filter.exclude()) {
            return this.empty();
        }
        if (this.isPagined()) {
            return this.delegate().filter(predicate);
        }
        if (!(predicate instanceof Filter)) {
            this.hasPredicates = true;
            return super.filter(predicate);
        }
        if (this.selection == null) {
            this.selection = new SelectionClause(this.table);
        }
        return this.execute(() -> {
            Stream<AbstractFeature> stream = this;
            Optimization optimization = new Optimization();
            optimization.setFinalFeatureType(this.table.featureType);
            for (Filter filter : optimization.applyAndDecompose((Filter)predicate)) {
                if (filter == Filter.include()) continue;
                if (filter == Filter.exclude()) {
                    return this.empty();
                }
                if (this.selection.tryAppend(this.getFilterToSQL(), (Filter<? super AbstractFeature>)filter)) continue;
                stream = stream == this ? super.filter(filter) : stream.filter((Predicate<AbstractFeature>)filter);
                this.hasPredicates = true;
            }
            return stream;
        });
    }

    @Override
    public Stream<AbstractFeature> distinct() {
        if (this.isPagined()) {
            return this.delegate().distinct();
        }
        this.distinct = true;
        return this;
    }

    @Override
    public Stream<AbstractFeature> unordered() {
        if (this.isPagined()) {
            return (Stream)this.delegate().unordered();
        }
        this.sort = null;
        return super.unordered();
    }

    @Override
    public Stream<AbstractFeature> sorted() {
        if (this.isPagined()) {
            return this.delegate().sorted();
        }
        return super.sorted();
    }

    @Override
    public Stream<AbstractFeature> sorted(Comparator<? super AbstractFeature> comparator) {
        if (this.isPagined() || this.hasComparator) {
            return this.delegate().sorted(comparator);
        }
        SortBy c = SortByComparator.concatenate(this.sort, comparator);
        if (c != null) {
            this.sort = c;
            return this;
        }
        this.hasComparator = true;
        return super.sorted(comparator);
    }

    @Override
    public Stream<AbstractFeature> skip(long n) {
        ArgumentChecks.ensurePositive((String)"n", (long)n);
        this.offset = Math.addExact(this.offset, n);
        if (this.count != 0L) {
            if (n >= this.count) {
                return this.empty();
            }
            this.count -= n;
        }
        return this;
    }

    @Override
    public Stream<AbstractFeature> limit(long maxSize) {
        ArgumentChecks.ensurePositive((String)"maxSize", (long)maxSize);
        if (maxSize == 0L) {
            return this.empty();
        }
        this.count = this.count != 0L ? Math.min(this.count, maxSize) : maxSize;
        return this;
    }

    @Override
    public <R> Stream<R> map(Function<? super AbstractFeature, ? extends R> mapper) {
        if (this.projection == null && mapper instanceof FeatureProjection) {
            this.projection = (FeatureProjection)mapper;
            return this;
        }
        PaginedStream<? extends R> stream = new PaginedStream<R>(super.map(mapper), this);
        stream.listener = this.listener;
        return stream;
    }

    @Override
    public long count() {
        if (this.hasPredicates || this.count != 0L) {
            return super.count();
        }
        this.lock(this.table.database.transactionLocks);
        try (Connection connection = this.getConnection();){
            String filter;
            this.makeReadOnly(connection);
            SQLBuilder sql = new SQLBuilder(this.table.database);
            sql.setCatalogAndSchema(connection);
            sql.append("SELECT ").append("COUNT(");
            if (this.distinct) {
                String separator = "DISTINCT ";
                for (Column attribute : this.table.attributes) {
                    sql.append(separator).appendIdentifier(attribute.label);
                    separator = ", ";
                }
            } else {
                sql.appendIdentifier(this.table.attributes[0].label);
            }
            this.table.appendFromClause(sql.append(')'));
            if (this.selection != null && (filter = this.selection.query(connection, null)) != null) {
                sql.append(" WHERE ").append(filter);
            }
            try (Statement st = connection.createStatement();
                 ResultSet rs = st.executeQuery(sql.toString());){
                while (true) {
                    if (rs.next()) {
                        long n = rs.getLong(1);
                        if (rs.wasNull()) continue;
                        long l = n;
                        return l;
                        continue;
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            throw FeatureStream.cannotExecute(e);
        }
        finally {
            this.unlock();
        }
        return Math.max(super.count() - this.offset, 0L);
    }

    private Connection getConnection() throws SQLException {
        return this.table.database.source.getConnection();
    }

    private void makeReadOnly(Connection connection) throws SQLException {
        if (this.table.database.dialect.supportsReadOnlyUpdate()) {
            connection.setReadOnly(true);
        }
    }

    @Override
    protected Spliterator<AbstractFeature> createSourceIterator() throws Exception {
        Table projected = this.table;
        Database<?> database = projected.database;
        this.lock(database.transactionLocks);
        Connection connection = this.getConnection();
        this.setCloseHandler(connection);
        this.makeReadOnly(connection);
        InfoStatements spatialInformation = database.getSpatialSchema().isPresent() ? database.createInfoStatements(connection) : null;
        FeatureProjection completion = null;
        FeatureProjection queriedProjection = this.projection;
        if (queriedProjection != null) {
            if (queriedProjection.hasOperations()) {
                SelectionClause columnSQL = new SelectionClause(projected);
                SelectionClauseWriter filterToSQL = this.getFilterToSQL();
                queriedProjection = queriedProjection.replaceExpressions((name, expression) -> {
                    JDBCType type = filterToSQL.writeFunction(columnSQL, (Expression<? super AbstractFeature, ?>)expression);
                    if (type != null) {
                        try {
                            columnSQL.append(" AS ").appendIdentifier(name);
                            String sql = columnSQL.query(connection, spatialInformation);
                            expression = new ComputedColumn(database, type, (String)name, sql);
                        }
                        catch (Exception e) {
                            throw FeatureStream.cannotExecute(e);
                        }
                    }
                    columnSQL.clear();
                    return expression;
                });
            }
            BitSet unhandled = new BitSet();
            HashSet<String> reusedNames = new HashSet<String>();
            projected = new Table(projected, queriedProjection, reusedNames, unhandled);
            completion = queriedProjection.forPreexistingFeatureInstances(unhandled.stream().toArray());
            if (completion != null && !reusedNames.containsAll(completion.requiredSourceProperties())) {
                projected = this.table;
                completion = queriedProjection;
            }
        }
        FeatureIterator features = new FeatureIterator(projected, connection, spatialInformation, this.distinct, this.selection, this.sort, this.offset, this.count, completion);
        this.setCloseHandler(features);
        this.selection = null;
        return features;
    }

    private SelectionClauseWriter getFilterToSQL() {
        if (this.filterToSQL == null) {
            this.filterToSQL = this.table.database.getFilterToSupportedSQL();
        }
        return this.filterToSQL;
    }

    public String toString() {
        Object[] objectArray = new Object[12];
        objectArray[0] = "table";
        objectArray[1] = this.table.name.table;
        objectArray[2] = "predicates";
        objectArray[3] = this.hasPredicates ? (this.filterToSQL != null ? "mixed" : "Java") : (this.selection != null ? "SQL" : null);
        objectArray[4] = "comparator";
        objectArray[5] = this.hasComparator ? (this.sort != null ? "mixed" : "Java") : (this.sort != null ? "SQL" : null);
        objectArray[6] = "distinct";
        objectArray[7] = this.distinct ? Boolean.TRUE : null;
        objectArray[8] = "offset";
        objectArray[9] = this.offset != 0L ? Long.valueOf(this.offset) : null;
        objectArray[10] = "count";
        objectArray[11] = this.count != 0L ? Long.valueOf(this.count) : null;
        return Strings.toString(this.getClass(), (Object[])objectArray);
    }
}

