/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderNotFoundException;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jackrabbit.vault.fs.api.VaultInputSource;
import org.apache.jackrabbit.vault.fs.config.DefaultMetaInf;
import org.apache.jackrabbit.vault.fs.config.MetaInf;
import org.apache.jackrabbit.vault.fs.io.AbstractArchive;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.h2.util.CloseWatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipNioArchive
extends AbstractArchive {
    private static final Logger log = LoggerFactory.getLogger(ZipNioArchive.class);
    private final Path path;
    private final boolean deleteAtClose;
    private DefaultMetaInf inf;
    private FileSystem zipFileSystem;
    private CloseWatcher watcher;

    public ZipNioArchive(Path path) {
        this(path, false);
    }

    public ZipNioArchive(Path path, boolean deleteAtClose) {
        this.path = path;
        this.zipFileSystem = null;
        this.deleteAtClose = deleteAtClose;
    }

    @Override
    public void open(boolean strict) throws IOException {
        if (this.zipFileSystem != null) {
            log.debug("Archive already open");
            return;
        }
        try {
            this.zipFileSystem = FileSystems.newFileSystem(this.path, (ClassLoader)null);
        }
        catch (ProviderNotFoundException e) {
            throw new IOException("Can not open zip file '" + this.path + "'", e);
        }
        ZipNioArchive.dumpUnclosedArchives();
        this.watcher = CloseWatcher.register(this, this.zipFileSystem, SHOULD_CREATE_STACK_TRACE);
    }

    @Override
    @Nullable
    public InputStream openInputStream(@Nullable Archive.Entry entry) throws IOException {
        if (entry == null) {
            return null;
        }
        if (this.zipFileSystem == null) {
            throw new ArchiveNotOpenException(this.path.toString());
        }
        return Files.newInputStream(((EntryImpl)entry).path, new OpenOption[0]);
    }

    @Override
    @Nullable
    public VaultInputSource getInputSource(@Nullable Archive.Entry entry) throws IOException {
        if (entry == null) {
            return null;
        }
        if (this.zipFileSystem == null) {
            throw new ArchiveNotOpenException(this.path.toString());
        }
        EntryImpl entryImpl = (EntryImpl)entry;
        return new VaultInputSourceImpl(entryImpl);
    }

    @Override
    @NotNull
    public Archive.Entry getRoot() throws IOException {
        return new EntryImpl(this.zipFileSystem.getRootDirectories().iterator().next());
    }

    @Override
    @NotNull
    public MetaInf getMetaInf() {
        if (this.inf == null) {
            try {
                this.inf = this.parseMetaInf();
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not retrieve meta data from " + this.path.toString(), e);
            }
        }
        return this.inf;
    }

    /*
     * Exception decompiling
     */
    @NotNull
    private DefaultMetaInf parseMetaInf() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String getSystemId(Path zipPath, Path pathInZip) {
        String systemId = zipPath.toString();
        systemId = systemId + "!/" + pathInZip;
        return systemId;
    }

    @Override
    public void close() {
        if (this.zipFileSystem != null) {
            CloseWatcher.unregister(this.watcher);
            try {
                this.zipFileSystem.close();
            }
            catch (IOException e) {
                log.warn("Error during close.", (Throwable)e);
            }
        }
        if (this.deleteAtClose) {
            try {
                Files.delete(this.path);
            }
            catch (IOException e) {
                log.warn("Could not delete " + this.path, (Throwable)e);
            }
        }
    }

    public final class ArchiveNotOpenException
    extends IllegalStateException {
        private static final long serialVersionUID = 5634035426424134529L;

        public ArchiveNotOpenException(String archivePath) {
            super("Archive '" + archivePath + "' not open");
        }
    }

    private static final class EntryImpl
    implements Archive.Entry {
        protected final Path path;
        private Map<String, EntryImpl> children;

        private EntryImpl(@NotNull Path path) {
            this.path = path;
        }

        @Override
        @NotNull
        public String getName() {
            int numNames = this.path.getNameCount();
            if (numNames == 0) {
                return "";
            }
            String name = this.path.getName(numNames - 1).toString();
            if (name.endsWith("/")) {
                name = name.substring(0, name.length() - 1);
            }
            return name;
        }

        @Override
        public boolean isDirectory() {
            return Files.isDirectory(this.path, new LinkOption[0]);
        }

        @Override
        @NotNull
        public Collection<? extends Archive.Entry> getChildren() {
            if (this.children == null) {
                this.children = this.populateChildren();
            }
            return this.children.values();
        }

        @NotNull
        private Map<String, EntryImpl> populateChildren() {
            Map<String, EntryImpl> map;
            block8: {
                Stream<Path> childStream = Files.list(this.path);
                try {
                    map = childStream.map(EntryImpl::new).collect(Collectors.toMap(EntryImpl::getName, Function.identity()));
                    if (childStream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (childStream != null) {
                            try {
                                childStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Could not retrieve children", e);
                    }
                }
                childStream.close();
            }
            return map;
        }

        @Override
        @Nullable
        public Archive.Entry getChild(@NotNull String name) {
            if (this.children == null) {
                this.children = this.populateChildren();
            }
            return this.children.get(name);
        }
    }

    private static final class VaultInputSourceImpl
    extends VaultInputSource {
        private final EntryImpl entryImpl;

        private VaultInputSourceImpl(EntryImpl entryImpl) {
            this.entryImpl = entryImpl;
        }

        @Override
        public InputStream getByteStream() {
            try {
                return Files.newInputStream(this.entryImpl.path, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not retrieve byte stream", e);
            }
        }

        @Override
        public long getContentLength() {
            try {
                return Files.size(this.entryImpl.path);
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not retrieve file size", e);
            }
        }

        @Override
        public long getLastModified() {
            try {
                return Files.getLastModifiedTime(this.entryImpl.path, new LinkOption[0]).toMillis();
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not retrieve last modification time", e);
            }
        }
    }
}

