/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.upgrade;

import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.syncope.core.persistence.jpa.upgrade.WiserSchemaTool;

public class GenerateUpgradeSQL {
    private static final String INIT_SQL_STATEMENTS = "INSERT INTO GroupTypeExtension SELECT * FROM TypeExtension;\nINSERT INTO GroupTypeExtension_Class SELECT * FROM TypeExtension_AnyTypeClass;\nDROP TABLE TypeExtension_AnyTypeClass;\nDROP TABLE TypeExtension;\n\nUPDATE SyncopeGroup SET userOwner_id=uManager_id;\nALTER TABLE SyncopeGroup DROP COLUMN userOwner_id;\nUPDATE SyncopeGroup SET groupOwner_id=gManager_id;\nALTER TABLE SyncopeGroup DROP COLUMN groupOwner_id;\n\nDROP TABLE SyncopeRole_DynRealm;\nDROP TABLE DynRealmMembership;\nDROP TABLE DynRealm;\nDROP TABLE UDynGroupMembership;\nDROP TABLE ADynGroupMembership;\nDROP TABLE UDynGroupMembers;\nDROP TABLE ADynGroupMembers;\nDROP TABLE DynRoleMembers;\nDROP TABLE DynRealmMembers;\n";
    private final JDBCConfiguration jdbcConf;

    public GenerateUpgradeSQL(JDBCConfiguration jdbcConf) {
        this.jdbcConf = jdbcConf;
    }

    public void run(Writer out) throws IOException, SQLException {
        WiserSchemaTool schemaTool = new WiserSchemaTool(this.jdbcConf, "add");
        schemaTool.setSchemaGroup(this.jdbcConf.getSchemaFactoryInstance().readSchema());
        schemaTool.setWriter(out);
        try (Writer writer = out;){
            schemaTool.run();
            out.append('\n').append(INIT_SQL_STATEMENTS).append('\n');
        }
    }
}

