/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.scheme;

import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupDDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupEmpty;
import org.apache.sysds.runtime.compress.colgroup.dictionary.DictionaryFactory;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.colgroup.scheme.DDCScheme;
import org.apache.sysds.runtime.compress.colgroup.scheme.ICLAScheme;
import org.apache.sysds.runtime.compress.utils.DoubleCountHashMap;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.Pair;

public class DDCSchemeSC
extends DDCScheme {
    private final DoubleCountHashMap map;

    private DDCSchemeSC(IColIndex cols, DoubleCountHashMap map) {
        super(cols);
        this.map = map;
    }

    protected DDCSchemeSC(ColGroupDDC g) {
        super(g.getColIndices());
        this.lastDict = g.getDictionary();
        int unique = this.lastDict.getNumberOfValues(1);
        this.map = new DoubleCountHashMap(unique);
        for (int i = 0; i < unique; ++i) {
            this.map.increment(this.lastDict.getValue(i));
        }
    }

    protected DDCSchemeSC(IColIndex cols) {
        super(cols);
        this.map = new DoubleCountHashMap(4);
    }

    @Override
    protected final Object getMap() {
        return this.map;
    }

    @Override
    protected ICLAScheme updateV(MatrixBlock data, IColIndex columns) {
        if (data.isEmpty()) {
            this.map.increment(0.0, data.getNumRows());
        } else if (data.isInSparseFormat()) {
            this.updateSparse(data, columns.get(0));
        } else if (data.getDenseBlock().isContiguous()) {
            this.updateDense(data, columns.get(0));
        } else {
            this.updateGeneric(data, columns.get(0));
        }
        return this;
    }

    private ICLAScheme updateSparse(MatrixBlock data, int col) {
        int nRow = data.getNumRows();
        SparseBlock sb = data.getSparseBlock();
        for (int i = 0; i < nRow; ++i) {
            this.map.increment(sb.get(i, col));
        }
        return this;
    }

    private ICLAScheme updateDense(MatrixBlock data, int col) {
        int nRow = data.getNumRows();
        double[] vals = data.getDenseBlockValues();
        int nCol = data.getNumColumns();
        int max = nRow * nCol;
        for (int off = col; off < max; off += nCol) {
            this.map.increment(vals[off]);
        }
        return this;
    }

    private ICLAScheme updateGeneric(MatrixBlock data, int col) {
        int nRow = data.getNumRows();
        DenseBlock db = data.getDenseBlock();
        for (int i = 0; i < nRow; ++i) {
            double[] c = db.values(i);
            int off = db.pos(i) + col;
            this.map.increment(c[off]);
        }
        return this;
    }

    @Override
    protected AColGroup encodeV(MatrixBlock data, IColIndex columns) {
        if (data.isEmpty()) {
            return new ColGroupEmpty(columns);
        }
        int nRow = data.getNumRows();
        AMapToData d = MapToFactory.create(nRow, this.map.size());
        this.encode(data, d, this.cols.get(0));
        if (this.lastDict == null || this.lastDict.getNumberOfValues(columns.size()) != this.map.size()) {
            this.lastDict = DictionaryFactory.create(this.map);
        }
        return ColGroupDDC.create(columns, this.lastDict, d, null);
    }

    private void encode(MatrixBlock data, AMapToData d, int col) {
        if (data.isInSparseFormat()) {
            this.encodeSparse(data, d, col);
        } else if (data.getDenseBlock().isContiguous()) {
            this.encodeDense(data, d, col);
        } else {
            this.encodeGeneric(data, d, col);
        }
    }

    private void encodeSparse(MatrixBlock data, AMapToData d, int col) {
        int nRow = data.getNumRows();
        SparseBlock sb = data.getSparseBlock();
        for (int i = 0; i < nRow; ++i) {
            d.set(i, this.map.getId(sb.get(i, col)));
        }
    }

    private void encodeDense(MatrixBlock data, AMapToData d, int col) {
        int nRow = data.getNumRows();
        double[] vals = data.getDenseBlockValues();
        int nCol = data.getNumColumns();
        int max = nRow * nCol;
        int i = 0;
        for (int off = col; off < max; off += nCol) {
            d.set(i, this.map.getId(vals[off]));
            ++i;
        }
    }

    private void encodeGeneric(MatrixBlock data, AMapToData d, int col) {
        int nRow = data.getNumRows();
        DenseBlock db = data.getDenseBlock();
        for (int i = 0; i < nRow; ++i) {
            double[] c = db.values(i);
            int off = db.pos(i) + col;
            d.set(i, this.map.getId(c[off]));
        }
    }

    @Override
    protected Pair<ICLAScheme, AColGroup> tryUpdateAndEncode(MatrixBlock data, IColIndex columns) {
        if (data.isEmpty()) {
            this.map.increment(0.0, data.getNumRows());
            return new Pair<ICLAScheme, AColGroup>(this, new ColGroupEmpty(columns));
        }
        int nRow = data.getNumRows();
        AMapToData d = MapToFactory.create(nRow, this.map.size());
        this.encodeAndUpdate(data, d, this.cols.get(0));
        if (this.lastDict == null || this.lastDict.getNumberOfValues(columns.size()) != this.map.size()) {
            this.lastDict = DictionaryFactory.create(this.map);
        }
        return new Pair<ICLAScheme, AColGroup>(this, ColGroupDDC.create(columns, this.lastDict, d, null));
    }

    private void encodeAndUpdate(MatrixBlock data, AMapToData d, int col) {
        int max = d.getUpperBoundValue();
        if (data.isInSparseFormat()) {
            this.encodeAndUpdateSparse(data, d, col, max);
        } else if (data.getDenseBlock().isContiguous()) {
            this.encodeAndUpdateDense(data, d, col, max);
        } else {
            this.encodeAndUpdateGeneric(data, d, col, max);
        }
    }

    private void encodeAndUpdateSparse(MatrixBlock data, AMapToData d, int col, int max) {
        int nRow = data.getNumRows();
        SparseBlock sb = data.getSparseBlock();
        for (int i = 0; i < nRow; ++i) {
            int id = this.map.increment(sb.get(i, col));
            if (id > max) {
                throw new DMLCompressionException("Failed update and encode with " + max + " possible values");
            }
            d.set(i, id);
        }
    }

    private void encodeAndUpdateDense(MatrixBlock data, AMapToData d, int col, int max) {
        int nRow = data.getNumRows();
        double[] vals = data.getDenseBlockValues();
        int nCol = data.getNumColumns();
        int end = nRow * nCol;
        int i = 0;
        for (int off = col; off < end; off += nCol) {
            int id = this.map.increment(vals[off]);
            if (id > max) {
                throw new DMLCompressionException("Failed update and encode with " + max + " possible values");
            }
            d.set(i, id);
            ++i;
        }
    }

    private void encodeAndUpdateGeneric(MatrixBlock data, AMapToData d, int col, int max) {
        int nRow = data.getNumRows();
        DenseBlock db = data.getDenseBlock();
        for (int i = 0; i < nRow; ++i) {
            int off;
            double[] c = db.values(i);
            int id = this.map.increment(c[off = db.pos(i) + col]);
            if (id > max) {
                throw new DMLCompressionException("Failed update and encode with " + max + " possible values");
            }
            d.set(i, id);
        }
    }

    @Override
    protected AColGroup encodeVT(MatrixBlock data, IColIndex columns) {
        if (data.isEmpty()) {
            return new ColGroupEmpty(columns);
        }
        int nRow = data.getNumColumns();
        AMapToData d = MapToFactory.create(nRow, this.map.size());
        this.encodeT(data, d, this.cols.get(0));
        if (this.lastDict == null || this.lastDict.getNumberOfValues(columns.size()) != this.map.size()) {
            this.lastDict = DictionaryFactory.create(this.map);
        }
        return ColGroupDDC.create(columns, this.lastDict, d, null);
    }

    private void encodeT(MatrixBlock data, AMapToData d, int col) {
        if (data.isInSparseFormat()) {
            this.encodeSparseT(data, d, col);
        } else {
            this.encodeDenseT(data, d, col);
        }
    }

    private void encodeSparseT(MatrixBlock data, AMapToData d, int col) {
        SparseBlock sb = data.getSparseBlock();
        d.fill(this.map.getId(0.0));
        if (!sb.isEmpty(col)) {
            int apos = sb.pos(col);
            int[] aix = sb.indexes(col);
            int alen = sb.size(col) + apos;
            double[] aval = sb.values(col);
            while (apos < alen) {
                double v = aval[apos];
                int idx = aix[apos++];
                d.set(idx, this.map.getId(v));
            }
        }
    }

    private void encodeDenseT(MatrixBlock data, AMapToData d, int col) {
        DenseBlock db = data.getDenseBlock();
        double[] vals = db.values(col);
        int nCol = data.getNumColumns();
        int i = 0;
        int off = db.pos(col);
        while (i < nCol) {
            d.set(i, this.map.getId(vals[off]));
            ++i;
            ++off;
        }
    }

    @Override
    protected ICLAScheme updateVT(MatrixBlock data, IColIndex columns) {
        if (data.isEmpty()) {
            this.map.increment(0.0, data.getNumColumns());
        } else if (data.isInSparseFormat()) {
            this.updateSparseT(data, columns.get(0));
        } else {
            this.updateDenseT(data, columns.get(0));
        }
        return this;
    }

    private void updateDenseT(MatrixBlock data, int col) {
        DenseBlock db = data.getDenseBlock();
        double[] vals = db.values(col);
        int nCol = data.getNumColumns();
        int i = 0;
        int off = db.pos(col);
        while (i < nCol) {
            this.map.increment(vals[off]);
            ++i;
            ++off;
        }
    }

    private void updateSparseT(MatrixBlock data, int col) {
        SparseBlock sb = data.getSparseBlock();
        if (!sb.isEmpty(col)) {
            int apos = sb.pos(col);
            int alen = sb.size(col) + apos;
            double[] aval = sb.values(col);
            this.map.increment(0.0, alen - apos);
            while (apos < alen) {
                this.map.increment(aval[apos++]);
            }
        } else {
            this.map.increment(0.0, data.getNumColumns());
        }
    }

    @Override
    protected Pair<ICLAScheme, AColGroup> tryUpdateAndEncodeT(MatrixBlock data, IColIndex columns) {
        if (data.isEmpty()) {
            return new Pair<ICLAScheme, AColGroup>(this, new ColGroupEmpty(columns));
        }
        int nRow = data.getNumColumns();
        AMapToData d = MapToFactory.create(nRow, this.map.size());
        this.encodeAndUpdateT(data, d, this.cols.get(0));
        if (this.lastDict == null || this.lastDict.getNumberOfValues(columns.size()) != this.map.size()) {
            this.lastDict = DictionaryFactory.create(this.map);
        }
        return new Pair<ICLAScheme, AColGroup>(this, ColGroupDDC.create(columns, this.lastDict, d, null));
    }

    private void encodeAndUpdateT(MatrixBlock data, AMapToData d, int col) {
        if (data.isInSparseFormat()) {
            this.encodeAndUpdateSparseT(data, d, col);
        } else {
            this.encodeAndUpdateDenseT(data, d, col);
        }
    }

    private void encodeAndUpdateSparseT(MatrixBlock data, AMapToData d, int col) {
        SparseBlock sb = data.getSparseBlock();
        if (!sb.isEmpty(col)) {
            int apos = sb.pos(col);
            int[] aix = sb.indexes(col);
            int alen = sb.size(col) + apos;
            d.fill(this.map.increment(0.0, data.getNumColumns() - alen - apos));
            double[] aval = sb.values(col);
            while (apos < alen) {
                double v = aval[apos];
                int idx = aix[apos++];
                d.set(idx, this.map.increment(v));
            }
        } else {
            d.fill(this.map.increment(0.0, data.getNumColumns()));
        }
    }

    private void encodeAndUpdateDenseT(MatrixBlock data, AMapToData d, int col) {
        DenseBlock db = data.getDenseBlock();
        double[] vals = db.values(col);
        int nCol = data.getNumColumns();
        int i = 0;
        int off = db.pos(col);
        while (i < nCol) {
            d.set(i, this.map.increment(vals[off]));
            ++i;
            ++off;
        }
    }

    @Override
    public DDCSchemeSC clone() {
        return new DDCSchemeSC(this.cols, this.map.clone());
    }
}

