/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.function.IntPredicate;
import org.apache.uima.internal.util.Common_hash_support;
import org.apache.uima.internal.util.IntListIterator;
import org.apache.uima.internal.util.IntVector;
import org.apache.uima.internal.util.Misc;
import org.apache.uima.internal.util.PositiveIntSet;
import org.apache.uima.util.impl.Constants;

public class IntHashSet
extends Common_hash_support
implements PositiveIntSet {
    public static final int SIZE_NEEDING_4_BYTES = 65534;
    private static final int REMOVED4 = Integer.MIN_VALUE;
    private static final int REMOVED2 = Short.MIN_VALUE;
    private int offset;
    private int[] keys4;
    private short[] keys2;
    private boolean isMake4;
    private int mostPositive = Integer.MIN_VALUE;
    private int mostNegative = Integer.MAX_VALUE;

    public IntHashSet() {
        this(10, 0);
    }

    public IntHashSet(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public IntHashSet(int initialSizeBeforeExpanding, int offset) {
        super(initialSizeBeforeExpanding);
        this.isMake4 = offset == Integer.MIN_VALUE;
        this.offset = this.isMake4 ? 0 : offset;
        this.newTable(this.initialCapacity);
        this.resetTable();
    }

    public static int tableSpace(int numberOfElements) {
        return Common_hash_support.tableSpace(numberOfElements, Float.valueOf(0.66f));
    }

    public boolean wontExpand() {
        return this.wontExpand(1);
    }

    public boolean wontExpand(int n) {
        return this.size() + this.removed + n < this.sizeWhichTriggersExpansion;
    }

    public int getSpaceUsedInWords() {
        return this.keys4 != null ? this.keys4.length : this.keys2.length >> 1;
    }

    public static int getSpaceOverheadInWords() {
        return 11;
    }

    private int getRawFromAdjKey(int adjKey) {
        assert (adjKey != Short.MIN_VALUE);
        return adjKey + this.offset + (adjKey < 0 ? 1 : 0);
    }

    private void resetTable() {
        this.mostPositive = Integer.MIN_VALUE;
        this.mostNegative = Integer.MAX_VALUE;
    }

    @Override
    public void clear() {
        super.clear();
        this.resetTable();
    }

    private boolean isAdjKeyOutOfRange(int adjKey) {
        return adjKey > Short.MAX_VALUE || adjKey <= Short.MIN_VALUE;
    }

    @Override
    public boolean contains(int rawKey) {
        int pos = this.findPosition(rawKey);
        if (pos == -1) {
            return false;
        }
        if (this.keys4 == null) {
            return this.keys2[pos] != 0;
        }
        return this.keys4[pos] != 0;
    }

    @Override
    public int find(int rawKey) {
        throw new UnsupportedOperationException();
    }

    private int findPosition(int rawKey) {
        if (rawKey == 0) {
            throw new IllegalArgumentException("0 is an invalid key");
        }
        if (this.keys4 == null) {
            int adjKey = this.getAdjKey(rawKey);
            if (this.isAdjKeyOutOfRange(adjKey)) {
                return -1;
            }
            if (rawKey == Short.MIN_VALUE) {
                throw new IllegalArgumentException(String.valueOf(Short.MIN_VALUE) + " is an invalid key");
            }
            return this.findPositionAdjKey(adjKey);
        }
        if (rawKey == Integer.MIN_VALUE) {
            throw new IllegalArgumentException(String.valueOf(Integer.MIN_VALUE) + " is an invalid key");
        }
        return this.findPosition4(rawKey);
    }

    private int findPosition4(int rawKey) {
        return super.findPosition(Misc.hashInt(rawKey), i -> this.keys4[i] == 0 || this.keys4[i] == rawKey, i -> this.keys4[i] == Integer.MIN_VALUE);
    }

    private int findPositionAdjKey(int adjKey) {
        return super.findPosition(Misc.hashInt(adjKey), i -> this.keys2[i] == 0 || this.keys2[i] == adjKey, i -> this.keys2[i] == Short.MIN_VALUE);
    }

    private int getAdjKey(int rawKey) {
        int adjKey;
        return adjKey - ((adjKey = rawKey - this.offset) <= 0 ? 1 : 0);
    }

    private void switchTo4byte() {
        short[] oldKeys = this.keys2;
        this.isMake4 = true;
        this.newTable(this.getCapacity());
        this.removed = 0;
        for (short adjKey : oldKeys) {
            if (adjKey == 0 || adjKey == Short.MIN_VALUE) continue;
            this.addInner4(this.getRawFromAdjKey(adjKey));
        }
    }

    @Override
    public boolean add(int rawKey) {
        if (rawKey == 0) {
            throw new IllegalArgumentException("argument must be non-zero");
        }
        if (this.size() == 0) {
            this.mostPositive = this.mostNegative = rawKey;
        } else {
            if (rawKey > this.mostPositive) {
                this.mostPositive = rawKey;
            }
            if (rawKey < this.mostNegative) {
                this.mostNegative = rawKey;
            }
        }
        if (this.keys4 != null) {
            if (rawKey == Integer.MIN_VALUE) {
                throw new IllegalArgumentException(String.valueOf(Integer.MIN_VALUE) + " is an invalid key");
            }
            return this.find4AndAddIfMissing(rawKey);
        }
        int adjKey = this.getAdjKey(rawKey);
        if (this.isAdjKeyOutOfRange(adjKey)) {
            this.switchTo4byte();
            return this.find4AndAddIfMissing(rawKey);
        }
        int i = this.findPositionAdjKey(adjKey);
        if (this.keys2[i] == adjKey) {
            return false;
        }
        this.keys2[this.found_removed != -1 ? this.found_removed : i] = (short)adjKey;
        this.commonPutOrAddNotFound();
        return true;
    }

    private boolean find4AndAddIfMissing(int rawKey) {
        int i = this.findPosition4(rawKey);
        if (this.keys4[i] == rawKey) {
            return false;
        }
        if (this.found_removed == -1) {
            this.keys4[i] = rawKey;
            this.incrementSize();
        } else {
            this.keys4[this.found_removed] = rawKey;
            this.commonPutOrAddNotFound();
        }
        return true;
    }

    private void addInner4(int rawKey) {
        int i = this.findPosition4(rawKey);
        assert (this.keys4[i] == 0);
        this.keys4[i] = rawKey;
    }

    private void addInner2(short adjKey) {
        int i = this.findPositionAdjKey(adjKey);
        assert (this.keys2[i] == 0);
        this.keys2[i] = adjKey;
    }

    @Override
    public boolean remove(int rawKey) {
        int pos = this.findPosition(rawKey);
        if (pos == -1 || (this.keys4 == null ? this.keys2[pos] == 0 : this.keys4[pos] == 0)) {
            return false;
        }
        if (this.keys4 == null) {
            this.keys2[pos] = Short.MIN_VALUE;
        } else {
            this.keys4[pos] = Integer.MIN_VALUE;
        }
        if (rawKey == this.mostPositive) {
            --this.mostPositive;
        }
        if (rawKey == this.mostNegative) {
            ++this.mostNegative;
        }
        this.commonRemove();
        return true;
    }

    public int getMostPositive() {
        return this.mostPositive;
    }

    public int getMostNegative() {
        return this.mostNegative;
    }

    @Override
    public void showHistogram() {
    }

    @Override
    public int get(int pos) {
        if (this.keys4 == null) {
            short adjKey = this.keys2[pos];
            if (adjKey == 0 || adjKey == Short.MIN_VALUE) {
                return 0;
            }
            return this.getRawFromAdjKey(adjKey);
        }
        int adjKey = this.keys4[pos];
        if (adjKey == 0 || adjKey == Integer.MIN_VALUE) {
            return 0;
        }
        return adjKey;
    }

    @Override
    public IntListIterator iterator() {
        return new IntHashSetIterator();
    }

    @Override
    public int moveToFirst() {
        return this.size() == 0 ? -1 : this.moveToNextFilled(0);
    }

    @Override
    public int moveToLast() {
        return this.size() == 0 ? -1 : this.moveToPreviousFilled(this.getCapacity() - 1);
    }

    @Override
    public int moveToNext(int position) {
        if (position < 0) {
            return position;
        }
        int n = this.moveToNextFilled(position + 1);
        return n >= this.getCapacity() ? -1 : n;
    }

    @Override
    public int moveToPrevious(int position) {
        if (position >= this.getCapacity()) {
            return -1;
        }
        return this.moveToPreviousFilled(position - 1);
    }

    @Override
    public boolean isValid(int position) {
        return position >= 0 && position < this.getCapacity();
    }

    @Override
    public void bulkAddTo(IntVector v) {
        if (null == this.keys4) {
            for (short k : this.keys2) {
                if (k == 0 || k == Short.MIN_VALUE) continue;
                v.add(this.getRawFromAdjKey(k));
            }
        } else {
            for (int k : this.keys4) {
                if (k == 0 || k == Integer.MIN_VALUE) continue;
                v.add(k);
            }
        }
    }

    @Override
    public int[] toIntArray() {
        int s = this.size();
        if (s == 0) {
            return Constants.EMPTY_INT_ARRAY;
        }
        int[] r = new int[this.size()];
        int pos = this.moveToFirst();
        for (int i = 0; i < r.length; ++i) {
            r[i] = this.get(pos);
            pos = this.moveToNextFilled(pos + 1);
        }
        return r;
    }

    public String toString() {
        return String.format("IntHashSet [loadFactor=%s, initialCapacity=%s, sizeWhichTriggersExpansion=%s, size=%s, offset=%s%n keys4=%s%n keys2=%s%n secondTimeShrinkable=%s, mostPositive=%s, mostNegative=%s]", Float.valueOf(this.loadFactor), this.initialCapacity, this.sizeWhichTriggersExpansion, this.size(), this.offset, Arrays.toString(this.keys4), Arrays.toString(this.keys2), this.secondTimeShrinkable, this.mostPositive, this.mostNegative);
    }

    boolean isShortHashSet() {
        return this.keys2 != null;
    }

    int getOffset() {
        return this.offset;
    }

    @Override
    protected boolean is_valid_key(int pos) {
        if (this.keys4 == null) {
            return this.keys2[pos] != 0 && this.keys2[pos] != Short.MIN_VALUE;
        }
        return this.keys4[pos] != 0 && this.keys4[pos] != Integer.MIN_VALUE;
    }

    @Override
    protected int keys_length() {
        return this.keys4 == null ? this.keys2.length : this.keys4.length;
    }

    @Override
    protected void newKeysAndValues(int capacity) {
        if (this.isMake4) {
            this.keys4 = new int[capacity];
            this.keys2 = null;
        } else {
            this.keys2 = new short[capacity];
            this.keys4 = null;
        }
    }

    @Override
    protected void clearKeysAndValues() {
        if (this.keys4 == null) {
            Arrays.fill(this.keys2, (short)0);
        } else {
            Arrays.fill(this.keys4, 0);
        }
        this.resetTable();
    }

    @Override
    protected void copy_to_new_table(int new_capacity, int old_capacity, Common_hash_support.CommonCopyOld2New commonCopy) {
        if (this.keys2 != null) {
            short[] oldKeys = this.keys2;
            IntPredicate oldKeyValid = i -> oldKeys[i] != 0 && oldKeys[i] != Short.MIN_VALUE;
            if (new_capacity >= 65536) {
                this.isMake4 = true;
                commonCopy.apply(i -> this.addInner4(this.getRawFromAdjKey(oldKeys[i])), oldKeyValid);
            } else {
                commonCopy.apply(i -> this.addInner2(oldKeys[i]), oldKeyValid);
            }
        } else {
            int[] oldKeys = this.keys4;
            commonCopy.apply(i -> this.addInner4(oldKeys[i]), i -> oldKeys[i] != 0 && oldKeys[i] != Integer.MIN_VALUE);
        }
    }

    private class IntHashSetIterator
    implements IntListIterator {
        private int curPosition = 0;

        private IntHashSetIterator() {
        }

        @Override
        public final boolean hasNext() {
            this.curPosition = IntHashSet.this.moveToNextFilled(this.curPosition);
            return this.curPosition < IntHashSet.this.getCapacity();
        }

        @Override
        public final int nextNvc() {
            this.curPosition = IntHashSet.this.moveToNextFilled(this.curPosition);
            int r = IntHashSet.this.get(this.curPosition);
            this.curPosition = IntHashSet.this.moveToNextFilled(this.curPosition + 1);
            return r;
        }

        @Override
        public boolean hasPrevious() {
            int prev = IntHashSet.this.moveToPreviousFilled(this.curPosition - 1);
            return prev >= 0;
        }

        @Override
        public int previous() {
            this.curPosition = IntHashSet.this.moveToPreviousFilled(this.curPosition - 1);
            if (this.curPosition < 0) {
                throw new NoSuchElementException();
            }
            return IntHashSet.this.get(this.curPosition);
        }

        @Override
        public int previousNvc() {
            this.curPosition = IntHashSet.this.moveToPreviousFilled(this.curPosition - 1);
            return IntHashSet.this.get(this.curPosition);
        }

        @Override
        public void moveToEnd() {
            this.curPosition = IntHashSet.this.getCapacity() - 1;
        }

        @Override
        public void moveToStart() {
            this.curPosition = 0;
        }
    }
}

