/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.shell.commands;

import java.util.ArrayList;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.PartialList;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.services.DefinitionsService;
import org.apache.unomi.api.services.EventService;
import org.apache.unomi.common.DataTable;
import org.apache.unomi.shell.commands.ListCommandSupport;

@Command(scope="unomi", name="event-search", description="This commands search for profile events of a certain type by last timestamp in the Apache Unomi Context Server")
@Service
public class EventSearch
extends ListCommandSupport {
    @Reference
    private EventService eventService;
    @Reference
    DefinitionsService definitionsService;
    @Argument(index=0, name="profile", description="The identifier for the profile", required=true, multiValued=false)
    String profileIdentifier;
    @Argument(index=1, name="eventType", description="The type of the event", required=false, multiValued=false)
    String eventTypeId;
    @Argument(index=2, name="maxEntries", description="The maximum number of entries to retrieve (defaults to 100)", required=false, multiValued=false)
    int maxEntries = 100;
    String[] columnHeaders = new String[]{"ID", "Type", "Session", "Profile", "Timestamp", "Scope", "Persistent"};

    @Override
    protected String[] getHeaders() {
        return this.columnHeaders;
    }

    @Override
    protected DataTable buildDataTable() {
        Condition booleanCondition = new Condition(this.definitionsService.getConditionType("booleanCondition"));
        booleanCondition.setParameter("operator", (Object)"and");
        ArrayList<Condition> subConditions = new ArrayList<Condition>();
        if (this.profileIdentifier != null) {
            Condition eventProfileIdCondition = new Condition(this.definitionsService.getConditionType("eventPropertyCondition"));
            eventProfileIdCondition.setParameter("propertyName", (Object)"profileId");
            eventProfileIdCondition.setParameter("comparisonOperator", (Object)"equals");
            eventProfileIdCondition.setParameter("propertyValue", (Object)this.profileIdentifier);
            subConditions.add(eventProfileIdCondition);
        }
        if (this.eventTypeId != null) {
            Condition eventTypeIdCondition = new Condition(this.definitionsService.getConditionType("eventTypeCondition"));
            eventTypeIdCondition.setParameter("eventTypeId", (Object)this.eventTypeId);
            subConditions.add(eventTypeIdCondition);
        }
        booleanCondition.setParameter("subConditions", subConditions);
        PartialList lastEvents = this.eventService.searchEvents(booleanCondition, 0, this.maxEntries);
        DataTable dataTable = new DataTable();
        for (Event event : lastEvents.getList()) {
            ArrayList<String> rowData = new ArrayList<String>();
            rowData.add(event.getItemId());
            rowData.add(event.getEventType());
            rowData.add(event.getSessionId());
            rowData.add(event.getProfileId());
            rowData.add(event.getTimeStamp().toString());
            rowData.add(event.getScope());
            rowData.add(Boolean.toString(event.isPersistent()));
            dataTable.addRow(rowData.toArray(new Comparable[rowData.size()]));
        }
        return dataTable;
    }
}

