/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.csp;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.wicket.Application;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.Page;
import org.apache.wicket.core.request.handler.IPageRequestHandler;
import org.apache.wicket.core.request.handler.RenderPageRequestHandler;
import org.apache.wicket.csp.CSPHeaderConfiguration;
import org.apache.wicket.csp.CSPHeaderMode;
import org.apache.wicket.csp.CSPNonceHeaderResponseDecorator;
import org.apache.wicket.csp.CSPRequestCycleListener;
import org.apache.wicket.csp.ReportCSPViolationMapper;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.lang.Args;

public class ContentSecurityPolicySettings {
    private static final int NONCE_LENGTH = 18;
    public static final MetaDataKey<String> NONCE_KEY = new MetaDataKey<String>(){
        private static final long serialVersionUID = 1L;
    };
    private final Map<CSPHeaderMode, CSPHeaderConfiguration> configs = new EnumMap<CSPHeaderMode, CSPHeaderConfiguration>(CSPHeaderMode.class);
    private Predicate<IRequestHandler> protectedFilter = RenderPageRequestHandler.class::isInstance;
    private Supplier<String> nonceCreator;

    public ContentSecurityPolicySettings(Application application) {
        Args.notNull((Object)application, (String)"application");
        this.nonceCreator = () -> application.getSecuritySettings().getRandomSupplier().getRandomBase64(18);
    }

    public CSPHeaderConfiguration blocking() {
        return this.configs.computeIfAbsent(CSPHeaderMode.BLOCKING, x -> new CSPHeaderConfiguration());
    }

    public CSPHeaderConfiguration reporting() {
        return this.configs.computeIfAbsent(CSPHeaderMode.REPORT_ONLY, x -> new CSPHeaderConfiguration());
    }

    public ContentSecurityPolicySettings setNonceCreator(Supplier<String> nonceCreator) {
        Args.notNull(nonceCreator, (String)"nonceCreator");
        this.nonceCreator = nonceCreator;
        return this;
    }

    public ContentSecurityPolicySettings setProtectedFilter(Predicate<IRequestHandler> protectedFilter) {
        Args.notNull(protectedFilter, (String)"protectedFilter");
        this.protectedFilter = protectedFilter;
        return this;
    }

    protected boolean mustProtectRequest(IRequestHandler handler) {
        return this.protectedFilter.test(handler);
    }

    public final boolean isNonceEnabled() {
        return this.configs.values().stream().anyMatch(CSPHeaderConfiguration::isNonceEnabled);
    }

    public String getNonce(RequestCycle cycle) {
        IRequestHandler handler = cycle.getActiveRequestHandler();
        Page currentPage = IPageRequestHandler.getPage(handler);
        String nonce = cycle.getMetaData(NONCE_KEY);
        if (nonce == null) {
            if (currentPage != null) {
                nonce = (String)currentPage.getMetaData((MetaDataKey)NONCE_KEY);
            }
            if (nonce == null) {
                nonce = this.createNonce();
            }
            cycle.setMetaData((MetaDataKey)NONCE_KEY, nonce);
        }
        if (currentPage != null) {
            currentPage.setMetaData(NONCE_KEY, nonce);
        }
        return nonce;
    }

    protected String createNonce() {
        return this.nonceCreator.get();
    }

    public Map<CSPHeaderMode, CSPHeaderConfiguration> getConfiguration() {
        return Collections.unmodifiableMap(this.configs);
    }

    public void enforce(WebApplication application) {
        application.getRequestCycleListeners().add(new CSPRequestCycleListener(this));
        application.getHeaderResponseDecorators().addPreResourceAggregationDecorator(response -> new CSPNonceHeaderResponseDecorator(response, this));
        application.mount((IRequestMapper)new ReportCSPViolationMapper(this));
    }

    public boolean isEnabled() {
        return this.configs.values().stream().anyMatch(CSPHeaderConfiguration::isSet);
    }
}

