/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.compile;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.JavaVersion;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.internal.FeaturePreviews;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.api.internal.tasks.compile.CleaningJavaCompiler;
import org.gradle.api.internal.tasks.compile.CommandLineJavaCompileSpec;
import org.gradle.api.internal.tasks.compile.CompilationSourceDirs;
import org.gradle.api.internal.tasks.compile.CompilerForkUtils;
import org.gradle.api.internal.tasks.compile.DefaultGroovyJavaJointCompileSpec;
import org.gradle.api.internal.tasks.compile.DefaultGroovyJavaJointCompileSpecFactory;
import org.gradle.api.internal.tasks.compile.GroovyCompilerFactory;
import org.gradle.api.internal.tasks.compile.GroovyJavaJointCompileSpec;
import org.gradle.api.internal.tasks.compile.HasCompileOptions;
import org.gradle.api.internal.tasks.compile.MinimalGroovyCompileOptions;
import org.gradle.api.internal.tasks.compile.incremental.IncrementalCompilerFactory;
import org.gradle.api.internal.tasks.compile.incremental.recomp.GroovyRecompilationSpecProvider;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpecProvider;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskOutputs;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.GroovyCompileOptions;
import org.gradle.internal.buildoption.FeatureFlag;
import org.gradle.internal.buildoption.FeatureFlags;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.instrumentation.api.annotations.ToBeReplacedByLazyProperty;
import org.gradle.jvm.toolchain.JavaInstallationMetadata;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.util.internal.GFileUtils;
import org.gradle.util.internal.IncubationLogger;
import org.gradle.work.Incremental;
import org.gradle.work.InputChanges;

@CacheableTask
public abstract class GroovyCompile
extends AbstractCompile
implements HasCompileOptions {
    private FileCollection groovyClasspath;
    private final ConfigurableFileCollection astTransformationClasspath;
    private final CompileOptions compileOptions;
    private final GroovyCompileOptions groovyCompileOptions = (GroovyCompileOptions)this.getProject().getObjects().newInstance(GroovyCompileOptions.class, new Object[0]);
    private final FileCollection stableSources = this.getProject().files(new Object[]{this::getSource});
    private final Property<JavaLauncher> javaLauncher;
    private File previousCompilationDataFile;

    public GroovyCompile() {
        ObjectFactory objectFactory = this.getObjectFactory();
        CompileOptions compileOptions = (CompileOptions)objectFactory.newInstance(CompileOptions.class, new Object[0]);
        compileOptions.setIncremental(false);
        compileOptions.getIncrementalAfterFailure().convention((Object)true);
        this.compileOptions = compileOptions;
        JavaToolchainService javaToolchainService = this.getJavaToolchainService();
        this.javaLauncher = objectFactory.property(JavaLauncher.class).convention(javaToolchainService.launcherFor(it -> {}));
        this.astTransformationClasspath = objectFactory.fileCollection();
        if (!this.experimentalCompilationAvoidanceEnabled()) {
            this.astTransformationClasspath.from(new Object[]{this::getClasspath});
        }
        CompilerForkUtils.doNotCacheIfForkingViaExecutable((CompileOptions)compileOptions, (TaskOutputs)this.getOutputs());
    }

    @CompileClasspath
    @Incremental
    @ToBeReplacedByLazyProperty
    public FileCollection getClasspath() {
        return super.getClasspath();
    }

    @Classpath
    public ConfigurableFileCollection getAstTransformationClasspath() {
        return this.astTransformationClasspath;
    }

    private boolean experimentalCompilationAvoidanceEnabled() {
        return this.getFeatureFlags().isEnabled((FeatureFlag)FeaturePreviews.Feature.GROOVY_COMPILATION_AVOIDANCE);
    }

    @TaskAction
    protected void compile(InputChanges inputChanges) {
        this.checkGroovyClasspathIsNonEmpty();
        this.warnIfCompileAvoidanceEnabled();
        GroovyJavaJointCompileSpec spec = this.createSpec();
        this.maybeDisableIncrementalCompilationAfterFailure(spec);
        WorkResult result = this.createCompiler(spec, inputChanges).execute((CompileSpec)spec);
        this.setDidWork(result.getDidWork());
    }

    private void maybeDisableIncrementalCompilationAfterFailure(GroovyJavaJointCompileSpec spec) {
        if (CommandLineJavaCompileSpec.class.isAssignableFrom(spec.getClass())) {
            spec.getCompileOptions().setSupportsIncrementalCompilationAfterFailure(false);
        }
    }

    @OutputFile
    protected File getPreviousCompilationData() {
        if (this.previousCompilationDataFile == null) {
            this.previousCompilationDataFile = new File(this.getTemporaryDirWithoutCreating(), "previous-compilation-data.bin");
        }
        return this.previousCompilationDataFile;
    }

    private void warnIfCompileAvoidanceEnabled() {
        if (this.experimentalCompilationAvoidanceEnabled()) {
            IncubationLogger.incubatingFeatureUsed((String)"Groovy compilation avoidance");
        }
    }

    private Compiler<GroovyJavaJointCompileSpec> createCompiler(GroovyJavaJointCompileSpec spec, InputChanges inputChanges) {
        GroovyCompilerFactory groovyCompilerFactory = this.getGroovyCompilerFactory();
        Compiler<GroovyJavaJointCompileSpec> delegatingCompiler = groovyCompilerFactory.newCompiler(spec);
        CleaningJavaCompiler cleaningGroovyCompiler = new CleaningJavaCompiler(delegatingCompiler, this.getOutputs(), this.getDeleter());
        if (spec.incrementalCompilationEnabled()) {
            IncrementalCompilerFactory factory = this.getIncrementalCompilerFactory();
            return factory.makeIncremental(cleaningGroovyCompiler, this.getStableSources().getAsFileTree(), this.createRecompilationSpecProvider(inputChanges));
        }
        return cleaningGroovyCompiler;
    }

    private RecompilationSpecProvider createRecompilationSpecProvider(InputChanges inputChanges) {
        FileCollection stableSources = this.getStableSources();
        return new GroovyRecompilationSpecProvider(this.getDeleter(), (FileOperations)this.getServices().get(FileOperations.class), stableSources.getAsFileTree(), inputChanges.isIncremental(), () -> inputChanges.getFileChanges(stableSources).iterator());
    }

    @SkipWhenEmpty
    @IgnoreEmptyDirectories
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    protected FileCollection getStableSources() {
        return this.stableSources;
    }

    private FileCollection determineGroovyCompileClasspath() {
        if (this.experimentalCompilationAvoidanceEnabled()) {
            return this.astTransformationClasspath.plus(this.getClasspath());
        }
        return this.getClasspath();
    }

    private static void validateIncrementalCompilationOptions(List<File> sourceRoots, boolean annotationProcessingConfigured) {
        if (sourceRoots.isEmpty()) {
            throw new InvalidUserDataException("Unable to infer source roots. Incremental Groovy compilation requires the source roots. Change the configuration of your sources or disable incremental Groovy compilation.");
        }
        if (annotationProcessingConfigured) {
            throw new InvalidUserDataException("Enabling incremental compilation and configuring Java annotation processors for Groovy compilation is not allowed. Disable incremental Groovy compilation or remove the Java annotation processor configuration.");
        }
    }

    private GroovyJavaJointCompileSpec createSpec() {
        DefaultGroovyJavaJointCompileSpec spec = (DefaultGroovyJavaJointCompileSpec)new DefaultGroovyJavaJointCompileSpecFactory(this.compileOptions, this.getToolchain()).create();
        assert (spec != null);
        FileTreeInternal stableSourcesAsFileTree = (FileTreeInternal)this.getStableSources().getAsFileTree();
        List sourceRoots = CompilationSourceDirs.inferSourceRoots((FileTreeInternal)stableSourcesAsFileTree);
        spec.setSourcesRoots(sourceRoots);
        spec.setSourceFiles((Iterable)stableSourcesAsFileTree);
        spec.setDestinationDir((File)this.getDestinationDirectory().getAsFile().get());
        spec.setWorkingDir(this.getProjectLayout().getProjectDirectory().getAsFile());
        spec.setTempDir(this.getTemporaryDir());
        spec.setCompileClasspath((List)ImmutableList.copyOf((Iterable)this.determineGroovyCompileClasspath()));
        this.configureCompatibilityOptions(spec);
        spec.setAnnotationProcessorPath(Lists.newArrayList((Iterable)(this.compileOptions.getAnnotationProcessorPath() == null ? this.getProjectLayout().files(new Object[0]) : this.compileOptions.getAnnotationProcessorPath())));
        spec.setGroovyClasspath(Lists.newArrayList((Iterable)this.getGroovyClasspath()));
        spec.setCompileOptions(this.compileOptions);
        spec.setGroovyCompileOptions(new MinimalGroovyCompileOptions(this.groovyCompileOptions));
        spec.getCompileOptions().setSupportsCompilerApi(true);
        if (this.getOptions().isIncremental()) {
            GroovyCompile.validateIncrementalCompilationOptions(sourceRoots, spec.annotationProcessingConfigured());
            spec.getCompileOptions().setPreviousCompilationDataFile(this.getPreviousCompilationData());
        }
        if (spec.getGroovyCompileOptions().getStubDir() == null) {
            File dir = new File(this.getTemporaryDir(), "groovy-java-stubs");
            GFileUtils.mkdirs((File)dir);
            spec.getGroovyCompileOptions().setStubDir(dir);
        }
        String executable = ((JavaLauncher)this.getJavaLauncher().get()).getExecutablePath().getAsFile().getAbsolutePath();
        spec.getCompileOptions().getForkOptions().setExecutable(executable);
        return spec;
    }

    private void configureCompatibilityOptions(DefaultGroovyJavaJointCompileSpec spec) {
        String targetCompatibility;
        String toolchainVersion = JavaVersion.toVersion((Object)this.getToolchain().getLanguageVersion().asInt()).toString();
        String sourceCompatibility = this.getSourceCompatibility();
        if (sourceCompatibility == null) {
            sourceCompatibility = toolchainVersion;
        }
        if ((targetCompatibility = this.getTargetCompatibility()) == null) {
            targetCompatibility = sourceCompatibility;
        }
        spec.setSourceCompatibility(sourceCompatibility);
        spec.setTargetCompatibility(targetCompatibility);
    }

    private JavaInstallationMetadata getToolchain() {
        return (JavaInstallationMetadata)this.javaLauncher.map(JavaLauncher::getMetadata).get();
    }

    private void checkGroovyClasspathIsNonEmpty() {
        if (this.getGroovyClasspath().isEmpty()) {
            throw new InvalidUserDataException("'" + this.getName() + ".groovyClasspath' must not be empty. If a Groovy compile dependency is provided, the 'groovy-base' plugin will attempt to configure 'groovyClasspath' automatically. Alternatively, you may configure 'groovyClasspath' explicitly.");
        }
    }

    @Input
    protected String getGroovyCompilerJvmVersion() {
        return this.getToolchain().getLanguageVersion().toString();
    }

    @Internal(value="tracked via stableSources")
    @ToBeReplacedByLazyProperty
    public FileTree getSource() {
        return super.getSource();
    }

    @Nested
    public GroovyCompileOptions getGroovyOptions() {
        return this.groovyCompileOptions;
    }

    @Nested
    public CompileOptions getOptions() {
        return this.compileOptions;
    }

    @Classpath
    @ToBeReplacedByLazyProperty
    public FileCollection getGroovyClasspath() {
        return this.groovyClasspath;
    }

    public void setGroovyClasspath(FileCollection groovyClasspath) {
        this.groovyClasspath = groovyClasspath;
    }

    @Nested
    public Property<JavaLauncher> getJavaLauncher() {
        return this.javaLauncher;
    }

    @Inject
    protected abstract IncrementalCompilerFactory getIncrementalCompilerFactory();

    @Inject
    protected abstract Deleter getDeleter();

    @Inject
    protected abstract ProjectLayout getProjectLayout();

    @Inject
    protected abstract ObjectFactory getObjectFactory();

    @Inject
    protected abstract GroovyCompilerFactory getGroovyCompilerFactory();

    @Inject
    protected abstract FeatureFlags getFeatureFlags();

    @Inject
    protected abstract JavaToolchainService getJavaToolchainService();

    private File getTemporaryDirWithoutCreating() {
        return ((TemporaryFileProvider)this.getServices().get(TemporaryFileProvider.class)).newTemporaryFile(new String[]{this.getName()});
    }
}

