/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.v8;

import com.eclipsesource.v8.V8RuntimeException;

public abstract class V8ScriptException
extends V8RuntimeException {
    private final String fileName;
    private final int lineNumber;
    private final String jsMessage;
    private final String sourceLine;
    private final int startColumn;
    private final int endColumn;
    private final String jsStackTrace;

    V8ScriptException(String fileName, int lineNumber, String jsMessage, String sourceLine, int startColumn, int endColumn, String jsStackTrace, Throwable cause) {
        this.fileName = fileName;
        this.lineNumber = lineNumber;
        this.jsMessage = jsMessage;
        this.sourceLine = sourceLine;
        this.startColumn = startColumn;
        this.endColumn = endColumn;
        this.jsStackTrace = jsStackTrace;
        if (cause != null) {
            this.initCause(cause);
        }
    }

    public String getJSStackTrace() {
        return this.jsStackTrace;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public String getSourceLine() {
        return this.sourceLine;
    }

    @Override
    public String toString() {
        StringBuilder result2 = new StringBuilder();
        result2.append(this.createMessageLine());
        result2.append(this.createMessageDetails());
        result2.append(this.createJSStackDetails());
        result2.append("\n");
        result2.append(this.getClass().getName());
        return result2.toString();
    }

    @Override
    public String getMessage() {
        return this.createMessageLine();
    }

    public String getJSMessage() {
        return this.jsMessage;
    }

    private String createMessageLine() {
        return this.fileName + ":" + this.lineNumber + ": " + this.jsMessage;
    }

    private String createJSStackDetails() {
        if (this.jsStackTrace != null) {
            return "\n" + this.jsStackTrace;
        }
        return "";
    }

    private String createMessageDetails() {
        StringBuilder result2 = new StringBuilder();
        if (this.sourceLine != null && !this.sourceLine.isEmpty()) {
            result2.append('\n');
            result2.append(this.sourceLine);
            result2.append('\n');
            if (this.startColumn >= 0) {
                result2.append(this.createCharSequence(this.startColumn, ' '));
                result2.append(this.createCharSequence(this.endColumn - this.startColumn, '^'));
            }
        }
        return result2.toString();
    }

    private char[] createCharSequence(int length, char c) {
        char[] result2 = new char[length];
        for (int i = 0; i < length; ++i) {
            result2[i] = c;
        }
        return result2;
    }
}

