/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.problems;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import org.gradle.internal.buildtree.BuildModelParameters;
import org.gradle.internal.code.UserCodeApplicationContext;
import org.gradle.internal.code.UserCodeSource;
import org.gradle.internal.problems.NoOpProblemDiagnosticsFactory;
import org.gradle.internal.problems.ProblemLocationAnalyzer;
import org.gradle.internal.problems.failure.Failure;
import org.gradle.internal.problems.failure.FailureFactory;
import org.gradle.problems.Location;
import org.gradle.problems.ProblemDiagnostics;
import org.gradle.problems.buildtree.ProblemDiagnosticsFactory;
import org.gradle.problems.buildtree.ProblemStream;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

public class DefaultProblemDiagnosticsFactory
implements ProblemDiagnosticsFactory {
    private static final ProblemStream.StackTraceTransformer NO_OP = new CopyStackTraceTransFormer();
    private static final Supplier<Throwable> EXCEPTION_FACTORY = new Supplier<Throwable>(){

        public Throwable get() {
            return new Exception();
        }
    };
    private static final int MAX_STACKTRACE_COUNT = 50;
    private static final int ISOLATED_PROJECTS_MAX_STACKTRACE_COUNT = 5000;
    private final FailureFactory failureFactory;
    private final ProblemLocationAnalyzer locationAnalyzer;
    private final UserCodeApplicationContext userCodeContext;
    private final int maxStackTraces;

    @Inject
    public DefaultProblemDiagnosticsFactory(FailureFactory failureFactory, ProblemLocationAnalyzer locationAnalyzer, UserCodeApplicationContext userCodeContext, BuildModelParameters buildModelParameters) {
        this(failureFactory, locationAnalyzer, userCodeContext, DefaultProblemDiagnosticsFactory.getMaxStackTraces(buildModelParameters));
    }

    private static int getMaxStackTraces(BuildModelParameters buildModelParameters) {
        return buildModelParameters.isIsolatedProjects() ? 5000 : 50;
    }

    @VisibleForTesting
    DefaultProblemDiagnosticsFactory(FailureFactory failureFactory, ProblemLocationAnalyzer locationAnalyzer, UserCodeApplicationContext userCodeContext, int maxStackTraces) {
        this.failureFactory = failureFactory;
        this.locationAnalyzer = locationAnalyzer;
        this.userCodeContext = userCodeContext;
        this.maxStackTraces = maxStackTraces;
    }

    @Override
    public ProblemStream newStream() {
        return new DefaultProblemStream();
    }

    @Override
    public ProblemStream newUnlimitedStream() {
        DefaultProblemStream defaultProblemStream = new DefaultProblemStream();
        defaultProblemStream.remainingStackTraces.set(Integer.MAX_VALUE);
        return defaultProblemStream;
    }

    @Override
    public ProblemDiagnostics forException(Throwable exception) {
        return this.locationFromStackTrace(exception, true, true, NO_OP);
    }

    private ProblemDiagnostics locationFromStackTrace(@Nullable Throwable throwable, boolean fromException, boolean keepException, ProblemStream.StackTraceTransformer transformer) {
        UserCodeApplicationContext.Application applicationContext = this.userCodeContext.current();
        if (applicationContext == null && throwable == null) {
            return NoOpProblemDiagnosticsFactory.EMPTY_DIAGNOSTICS;
        }
        List<StackTraceElement> stackTrace = Collections.emptyList();
        Failure stackTracingFailure = null;
        Location location = null;
        if (throwable != null) {
            stackTrace = transformer.transform(throwable.getStackTrace());
            stackTracingFailure = this.failureFactory.create(throwable);
            location = this.locationAnalyzer.locationForUsage(stackTracingFailure, fromException);
        }
        UserCodeSource source = applicationContext != null ? applicationContext.getSource() : null;
        return new DefaultProblemDiagnostics(stackTracingFailure, keepException ? throwable : null, stackTrace, location, source);
    }

    @NullMarked
    private class DefaultProblemStream
    implements ProblemStream {
        private final AtomicInteger remainingStackTraces = new AtomicInteger();

        public DefaultProblemStream() {
            this.remainingStackTraces.set(DefaultProblemDiagnosticsFactory.this.maxStackTraces);
        }

        @Override
        public ProblemDiagnostics forCurrentCaller(@Nullable Throwable exception) {
            if (exception == null) {
                return DefaultProblemDiagnosticsFactory.this.locationFromStackTrace(this.getImplicitThrowable((Supplier<? extends Throwable>)EXCEPTION_FACTORY), false, false, NO_OP);
            }
            return DefaultProblemDiagnosticsFactory.this.locationFromStackTrace(exception, true, true, NO_OP);
        }

        @Override
        public ProblemDiagnostics forCurrentCaller() {
            return DefaultProblemDiagnosticsFactory.this.locationFromStackTrace(this.getImplicitThrowable((Supplier<? extends Throwable>)EXCEPTION_FACTORY), false, false, NO_OP);
        }

        @Override
        public ProblemDiagnostics forCurrentCaller(Supplier<? extends Throwable> exceptionFactory) {
            return DefaultProblemDiagnosticsFactory.this.locationFromStackTrace(this.getImplicitThrowable(exceptionFactory), false, true, NO_OP);
        }

        @Override
        public ProblemDiagnostics forCurrentCaller(ProblemStream.StackTraceTransformer transformer) {
            return DefaultProblemDiagnosticsFactory.this.locationFromStackTrace(this.getImplicitThrowable((Supplier<? extends Throwable>)EXCEPTION_FACTORY), false, false, transformer);
        }

        private @Nullable Throwable getImplicitThrowable(Supplier<? extends Throwable> factory) {
            if (this.remainingStackTraces.getAndDecrement() > 0) {
                return (Throwable)factory.get();
            }
            return null;
        }
    }

    private static class DefaultProblemDiagnostics
    implements ProblemDiagnostics {
        private final Failure failure;
        private final Throwable exception;
        private final List<StackTraceElement> stackTrace;
        private final Location location;
        private final UserCodeSource source;

        public DefaultProblemDiagnostics(@Nullable Failure stackTracingFailure, @Nullable Throwable exception, List<StackTraceElement> stackTrace, @Nullable Location location, @Nullable UserCodeSource source) {
            this.failure = stackTracingFailure;
            this.exception = exception;
            this.stackTrace = stackTrace;
            this.location = location;
            this.source = source;
        }

        @Override
        public @Nullable Failure getFailure() {
            return this.failure;
        }

        @Override
        public @Nullable Throwable getException() {
            return this.exception;
        }

        @Override
        public List<StackTraceElement> getStack() {
            return this.stackTrace;
        }

        @Override
        public @Nullable Location getLocation() {
            return this.location;
        }

        @Override
        public @Nullable UserCodeSource getSource() {
            return this.source;
        }
    }

    private static class CopyStackTraceTransFormer
    implements ProblemStream.StackTraceTransformer {
        private CopyStackTraceTransFormer() {
        }

        @Override
        public List<StackTraceElement> transform(StackTraceElement[] original) {
            return ImmutableList.copyOf((Object[])original);
        }
    }
}

