/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.connection;

import javax.jms.CompletionListener;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import org.springframework.lang.Nullable;

class CachedMessageProducer
implements MessageProducer,
QueueSender,
TopicPublisher {
    private final MessageProducer target;
    @Nullable
    private Boolean originalDisableMessageID;
    @Nullable
    private Boolean originalDisableMessageTimestamp;
    @Nullable
    private Long originalDeliveryDelay;
    private int deliveryMode;
    private int priority;
    private long timeToLive;

    public CachedMessageProducer(MessageProducer target) throws JMSException {
        this.target = target;
        this.deliveryMode = target.getDeliveryMode();
        this.priority = target.getPriority();
        this.timeToLive = target.getTimeToLive();
    }

    @Override
    public void setDisableMessageID(boolean disableMessageID) throws JMSException {
        if (this.originalDisableMessageID == null) {
            this.originalDisableMessageID = this.target.getDisableMessageID();
        }
        this.target.setDisableMessageID(disableMessageID);
    }

    @Override
    public boolean getDisableMessageID() throws JMSException {
        return this.target.getDisableMessageID();
    }

    @Override
    public void setDisableMessageTimestamp(boolean disableMessageTimestamp) throws JMSException {
        if (this.originalDisableMessageTimestamp == null) {
            this.originalDisableMessageTimestamp = this.target.getDisableMessageTimestamp();
        }
        this.target.setDisableMessageTimestamp(disableMessageTimestamp);
    }

    @Override
    public boolean getDisableMessageTimestamp() throws JMSException {
        return this.target.getDisableMessageTimestamp();
    }

    @Override
    public void setDeliveryDelay(long deliveryDelay) throws JMSException {
        if (this.originalDeliveryDelay == null) {
            this.originalDeliveryDelay = this.target.getDeliveryDelay();
        }
        this.target.setDeliveryDelay(deliveryDelay);
    }

    @Override
    public long getDeliveryDelay() throws JMSException {
        return this.target.getDeliveryDelay();
    }

    @Override
    public void setDeliveryMode(int deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    @Override
    public int getDeliveryMode() {
        return this.deliveryMode;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    @Override
    public long getTimeToLive() {
        return this.timeToLive;
    }

    @Override
    public Destination getDestination() throws JMSException {
        return this.target.getDestination();
    }

    @Override
    public Queue getQueue() throws JMSException {
        return (Queue)this.target.getDestination();
    }

    @Override
    public Topic getTopic() throws JMSException {
        return (Topic)this.target.getDestination();
    }

    @Override
    public void send(Message message) throws JMSException {
        this.target.send(message, this.deliveryMode, this.priority, this.timeToLive);
    }

    @Override
    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.target.send(message, deliveryMode, priority, timeToLive);
    }

    @Override
    public void send(Destination destination, Message message) throws JMSException {
        this.target.send(destination, message, this.deliveryMode, this.priority, this.timeToLive);
    }

    @Override
    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.target.send(destination, message, deliveryMode, priority, timeToLive);
    }

    @Override
    public void send(Message message, CompletionListener completionListener) throws JMSException {
        this.target.send(message, this.deliveryMode, this.priority, this.timeToLive, completionListener);
    }

    @Override
    public void send(Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        this.target.send(message, deliveryMode, priority, timeToLive, completionListener);
    }

    @Override
    public void send(Destination destination, Message message, CompletionListener completionListener) throws JMSException {
        this.target.send(destination, message, this.deliveryMode, this.priority, this.timeToLive, completionListener);
    }

    @Override
    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        this.target.send(destination, message, deliveryMode, priority, timeToLive, completionListener);
    }

    @Override
    public void send(Queue queue, Message message) throws JMSException {
        this.target.send(queue, message, this.deliveryMode, this.priority, this.timeToLive);
    }

    @Override
    public void send(Queue queue, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.target.send(queue, message, deliveryMode, priority, timeToLive);
    }

    @Override
    public void publish(Message message) throws JMSException {
        this.target.send(message, this.deliveryMode, this.priority, this.timeToLive);
    }

    @Override
    public void publish(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.target.send(message, deliveryMode, priority, timeToLive);
    }

    @Override
    public void publish(Topic topic, Message message) throws JMSException {
        this.target.send(topic, message, this.deliveryMode, this.priority, this.timeToLive);
    }

    @Override
    public void publish(Topic topic, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.target.send(topic, message, deliveryMode, priority, timeToLive);
    }

    @Override
    public void close() throws JMSException {
        if (this.originalDisableMessageID != null) {
            this.target.setDisableMessageID(this.originalDisableMessageID);
            this.originalDisableMessageID = null;
        }
        if (this.originalDisableMessageTimestamp != null) {
            this.target.setDisableMessageTimestamp(this.originalDisableMessageTimestamp);
            this.originalDisableMessageTimestamp = null;
        }
        if (this.originalDeliveryDelay != null) {
            this.target.setDeliveryDelay(this.originalDeliveryDelay);
            this.originalDeliveryDelay = null;
        }
    }

    public String toString() {
        return "Cached JMS MessageProducer: " + this.target;
    }
}

