/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.beanutils.AlphaBean;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.beanutils.TestBean;

public class BeanComparatorTestCase
extends TestCase {
    protected TestBean bean;
    protected AlphaBean alphaBean1;
    protected AlphaBean alphaBean2;

    public static Test suite() {
        return new TestSuite(BeanComparatorTestCase.class);
    }

    public BeanComparatorTestCase(String name) {
        super(name);
    }

    public void setUp() {
        this.bean = new TestBean();
        this.alphaBean1 = new AlphaBean("alphaBean1");
        this.alphaBean2 = new AlphaBean("alphaBean2");
    }

    public void tearDown() {
        this.bean = null;
        this.alphaBean1 = null;
        this.alphaBean2 = null;
    }

    public void testCompareBeanAgainstSelf() {
        BeanComparator beanComparator = new BeanComparator("name");
        int result = beanComparator.compare((Object)this.alphaBean1, (Object)this.alphaBean1);
        BeanComparatorTestCase.assertTrue((String)("Comparator did not sort properly.  Result:" + result), (result == 0 ? 1 : 0) != 0);
    }

    public void testCompareIdentical() {
        this.alphaBean1 = new AlphaBean("alphabean");
        this.alphaBean2 = new AlphaBean("alphabean");
        BeanComparator beanComparator = new BeanComparator("name");
        int result = beanComparator.compare((Object)this.alphaBean1, (Object)this.alphaBean2);
        BeanComparatorTestCase.assertTrue((String)("Comparator did not sort properly.  Result:" + result), (result == 0 ? 1 : 0) != 0);
    }

    public void testCompareOnBooleanProperty() {
        try {
            TestBean testBeanA = new TestBean();
            TestBean testBeanB = new TestBean();
            testBeanA.setBooleanProperty(true);
            testBeanB.setBooleanProperty(false);
            BeanComparator beanComparator = new BeanComparator("booleanProperty");
            beanComparator.compare((Object)testBeanA, (Object)testBeanB);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void testCompareOnMissingProperty() {
        try {
            BeanComparator beanComparator = new BeanComparator("bogusName");
            beanComparator.compare((Object)this.alphaBean2, (Object)this.alphaBean1);
            BeanComparatorTestCase.fail((String)"should not be able to compare");
        }
        catch (Exception e) {
            BeanComparatorTestCase.assertTrue((String)("Wrong exception was thrown: " + e), (e.toString().indexOf("Unknown property") > -1 ? 1 : 0) != 0);
        }
    }

    public void testCompareWithNulls() {
        try {
            BeanComparator beanComparator = new BeanComparator("name");
            beanComparator.compare((Object)this.alphaBean2, null);
            BeanComparatorTestCase.fail((String)"Should not be able to compare a null value.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testSetProperty() {
        TestBean testBeanA = new TestBean();
        TestBean testBeanB = new TestBean();
        testBeanA.setDoubleProperty(5.5);
        testBeanB.setDoubleProperty(1.0);
        BeanComparator beanComparator = new BeanComparator("doubleProperty");
        int result = beanComparator.compare((Object)testBeanA, (Object)testBeanB);
        BeanComparatorTestCase.assertTrue((String)("Comparator did not sort properly.  Result:" + result), (result == 1 ? 1 : 0) != 0);
        testBeanA.setStringProperty("string 1");
        testBeanB.setStringProperty("string 2");
        beanComparator.setProperty("stringProperty");
        result = beanComparator.compare((Object)testBeanA, (Object)testBeanB);
        BeanComparatorTestCase.assertTrue((String)("Comparator did not sort properly.  Result:" + result), (result == -1 ? 1 : 0) != 0);
    }

    public void testSimpleCompare() {
        BeanComparator beanComparator = new BeanComparator("name");
        int result = beanComparator.compare((Object)this.alphaBean1, (Object)this.alphaBean2);
        BeanComparatorTestCase.assertTrue((String)("Comparator did not sort properly.  Result:" + result), (result == -1 ? 1 : 0) != 0);
    }

    public void testSimpleCompareInverse() {
        BeanComparator beanComparator = new BeanComparator("name");
        int result = beanComparator.compare((Object)this.alphaBean2, (Object)this.alphaBean1);
        BeanComparatorTestCase.assertTrue((String)("Comparator did not sort properly.  Result:" + result), (result == 1 ? 1 : 0) != 0);
    }
}

