/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestImmutableNode {
    private static final String NAME = "testNode";
    private static final String ATTR = "attr";
    private static final String ATTR_VALUE = "attrValue";
    private static final Integer VALUE = 42;
    private int childCounter;

    private static void checkAttributes(ImmutableNode node, Map<String, ?> expAttrs) {
        Assertions.assertEquals(expAttrs, (Object)node.getAttributes());
    }

    private static void checkAttributesContained(ImmutableNode node, Map<String, Object> attributes) {
        for (Map.Entry<String, Object> e : attributes.entrySet()) {
            Assertions.assertEquals((Object)e.getValue(), node.getAttributes().get(e.getKey()));
        }
    }

    private static void checkChildNodes(ImmutableNode parent, ImmutableNode ... children) {
        TestImmutableNode.checkChildNodes(parent, Arrays.asList(children));
    }

    private static void checkChildNodes(ImmutableNode node, List<ImmutableNode> expChildren) {
        Assertions.assertEquals(expChildren, (Object)node.getChildren());
    }

    private static void checkUpdatedNode(ImmutableNode org, ImmutableNode updated) {
        Assertions.assertNotSame((Object)org, (Object)updated);
        Assertions.assertEquals((Object)NAME, (Object)updated.getNodeName());
        Assertions.assertEquals((Object)VALUE, (Object)updated.getValue());
    }

    private static ImmutableNode.Builder setUpBuilder() {
        ImmutableNode.Builder builder = new ImmutableNode.Builder();
        builder.name(NAME).value((Object)VALUE);
        return builder;
    }

    private void checkSetAttributesNoOp(Map<String, Object> attributes) {
        ImmutableNode node = this.createDefaultNode(VALUE);
        Assertions.assertSame((Object)node, (Object)node.setAttributes(attributes));
    }

    private ImmutableNode createChild() {
        int idx = this.childCounter++;
        return new ImmutableNode.Builder().name("Child" + idx).value((Object)("childValue" + idx)).create();
    }

    private ImmutableNode createDefaultNode(Object value) {
        return this.createDefaultNode(NAME, value);
    }

    private ImmutableNode createDefaultNode(String name, Object value) {
        ImmutableNode.Builder builder = new ImmutableNode.Builder(1);
        return builder.name(name).addChild(this.createChild()).addAttribute("testAttr", (Object)"anotherTest").value(value).create();
    }

    @Test
    void testAddAttributesNull() {
        ImmutableNode.Builder builder = TestImmutableNode.setUpBuilder();
        builder.addAttributes(null);
        ImmutableNode node = builder.create();
        Assertions.assertTrue((boolean)node.getAttributes().isEmpty());
    }

    @Test
    void testAddChild() {
        ImmutableNode node = this.createDefaultNode(VALUE);
        ImmutableNode child2 = new ImmutableNode.Builder().name("child2").create();
        ImmutableNode node2 = node.addChild(child2);
        TestImmutableNode.checkUpdatedNode(node, node2);
        TestImmutableNode.checkChildNodes(node2, (ImmutableNode)node.getChildren().get(0), child2);
    }

    @Test
    void testAddChildNull() {
        ImmutableNode node = this.createDefaultNode(VALUE);
        Assertions.assertThrows(IllegalArgumentException.class, () -> node.addChild(null));
    }

    @Test
    void testAddChildrenNull() {
        ImmutableNode.Builder builder = TestImmutableNode.setUpBuilder();
        builder.addChildren(null);
        ImmutableNode node = builder.create();
        Assertions.assertTrue((boolean)node.getChildren().isEmpty());
    }

    @Test
    void testAddChildrenNullElement() {
        ImmutableNode.Builder builder = TestImmutableNode.setUpBuilder();
        List<ImmutableNode> children = Arrays.asList(this.createChild(), null, this.createChild());
        builder.addChildren(children);
        ImmutableNode node = builder.create();
        TestImmutableNode.checkChildNodes(node, children.get(0), children.get(2));
    }

    @Test
    void testAttributesImmutable() {
        ImmutableNode node = TestImmutableNode.setUpBuilder().create();
        Map attributes = node.getAttributes();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> attributes.put("test", VALUE));
    }

    @Test
    void testChildrenImmutable() {
        ImmutableNode node = TestImmutableNode.setUpBuilder().create();
        List children = node.getChildren();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> children.add(null));
    }

    @Test
    void testGetChildrenByMissingName() {
        ImmutableNode node = this.createDefaultNode(VALUE);
        ImmutableNode child2 = new ImmutableNode.Builder().name("child2").create();
        ImmutableNode node2 = node.addChild(child2);
        TestImmutableNode.checkUpdatedNode(node, node2);
        Assertions.assertTrue((boolean)node2.getChildren("NotFound").isEmpty());
    }

    @Test
    void testGetChildrenByName() {
        ImmutableNode node = this.createDefaultNode(VALUE);
        ImmutableNode child2 = new ImmutableNode.Builder().name("child2").create();
        ImmutableNode node2 = node.addChild(child2);
        TestImmutableNode.checkUpdatedNode(node, node2);
        Assertions.assertEquals((Object)"child2", (Object)((ImmutableNode)node2.getChildren("child2").get(0)).getNodeName());
        Assertions.assertEquals((Object)child2, node2.getChildren("child2").get(0));
    }

    @Test
    void testGetChildrenByNullName() {
        ImmutableNode node = this.createDefaultNode(VALUE);
        ImmutableNode child2 = new ImmutableNode.Builder().name("child2").create();
        ImmutableNode node2 = node.addChild(child2);
        TestImmutableNode.checkUpdatedNode(node, node2);
        Assertions.assertTrue((boolean)node2.getChildren(null).isEmpty());
    }

    @Test
    void testNodeWithAddMultipleChildren() {
        int childCount = 4;
        ArrayList<ImmutableNode> childNodes = new ArrayList<ImmutableNode>(4);
        for (int i = 0; i < 4; ++i) {
            ImmutableNode.Builder childBuilder = new ImmutableNode.Builder();
            ImmutableNode child = childBuilder.name(NAME + i).value((Object)i).create();
            childNodes.add(child);
        }
        ImmutableNode.Builder builder = TestImmutableNode.setUpBuilder();
        ImmutableNode node = builder.addChildren(childNodes).create();
        TestImmutableNode.checkChildNodes(node, childNodes);
    }

    @Test
    void testNodeWithAttributes() {
        ImmutableNode.Builder builder = TestImmutableNode.setUpBuilder();
        int attrCount = 4;
        HashMap<String, Integer> attrs = new HashMap<String, Integer>();
        for (int i = 0; i < 4; ++i) {
            String attrName = NAME + i;
            attrs.put(attrName, i);
            builder.addAttribute(attrName, (Object)i);
        }
        ImmutableNode node = builder.create();
        TestImmutableNode.checkAttributes(node, attrs);
    }

    @Test
    void testNodeWithAttributesManipulateLater() {
        ImmutableNode.Builder builder = TestImmutableNode.setUpBuilder();
        builder.addAttribute(ATTR, (Object)ATTR_VALUE);
        ImmutableNode node = builder.create();
        builder.addAttribute("attr2", (Object)"a2");
        Assertions.assertEquals((int)1, (int)node.getAttributes().size());
        Assertions.assertEquals((Object)ATTR_VALUE, node.getAttributes().get(ATTR));
    }

    @Test
    void testNodeWithChildren() {
        int childCount = 8;
        ArrayList<ImmutableNode> childNodes = new ArrayList<ImmutableNode>(8);
        ImmutableNode.Builder builder = new ImmutableNode.Builder(8);
        for (int i = 0; i < 8; ++i) {
            ImmutableNode.Builder childBuilder = new ImmutableNode.Builder();
            ImmutableNode child = childBuilder.name(NAME + i).value((Object)i).create();
            builder.addChild(child);
            childNodes.add(child);
        }
        ImmutableNode node = builder.name(NAME).create();
        TestImmutableNode.checkChildNodes(node, childNodes);
    }

    @Test
    void testNodeWithChildrenManipulateLater() {
        ImmutableNode.Builder builder = TestImmutableNode.setUpBuilder();
        ImmutableNode child = new ImmutableNode.Builder().name("Child").create();
        ImmutableNode node = builder.addChild(child).create();
        builder.addChild(new ImmutableNode.Builder().name("AnotherChild").create());
        TestImmutableNode.checkChildNodes(node, Collections.singletonList(child));
    }

    @Test
    void testNodeWithMultipleAttributes() {
        ImmutableNode.Builder builder = TestImmutableNode.setUpBuilder();
        int attrCount = 4;
        HashMap<String, Integer> attrs = new HashMap<String, Integer>();
        for (int i = 0; i < 4; ++i) {
            String attrName = NAME + i;
            attrs.put(attrName, i);
        }
        ImmutableNode node = builder.addAttributes(attrs).create();
        TestImmutableNode.checkAttributes(node, attrs);
    }

    @Test
    void testNodeWithNullChild() {
        ImmutableNode.Builder builder = TestImmutableNode.setUpBuilder();
        builder.addChild(null);
        ImmutableNode node = builder.create();
        TestImmutableNode.checkChildNodes(node, new ImmutableNode[0]);
    }

    @Test
    void testRemoveAttributeExisting() {
        ImmutableNode node = this.createDefaultNode(VALUE);
        String attrName = (String)node.getAttributes().keySet().iterator().next();
        ImmutableNode node2 = node.removeAttribute(attrName);
        TestImmutableNode.checkUpdatedNode(node, node2);
        Assertions.assertSame((Object)node.getChildren(), (Object)node2.getChildren());
        Assertions.assertTrue((boolean)node2.getAttributes().isEmpty());
    }

    @Test
    void testRemoveAttributeNotExisting() {
        ImmutableNode node = this.createDefaultNode(VALUE);
        Assertions.assertSame((Object)node, (Object)node.removeAttribute(ATTR));
    }

    @Test
    void testRemoveChildExisting() {
        ImmutableNode node = this.createDefaultNode(VALUE);
        ImmutableNode child = (ImmutableNode)node.getChildren().get(0);
        ImmutableNode node2 = node.removeChild(child);
        TestImmutableNode.checkUpdatedNode(node, node2);
        TestImmutableNode.checkChildNodes(node2, new ImmutableNode[0]);
    }

    @Test
    void testRemoveChildMultiple() {
        ImmutableNode childRemove = this.createChild();
        ImmutableNode node = this.createDefaultNode(VALUE).addChild(this.createChild()).addChild(childRemove).addChild(this.createChild());
        ImmutableNode node2 = node.removeChild(childRemove);
        TestImmutableNode.checkChildNodes(node2, (ImmutableNode)node.getChildren().get(0), (ImmutableNode)node.getChildren().get(1), (ImmutableNode)node.getChildren().get(3));
    }

    @Test
    void testRemoveChildNodeNotExisting() {
        ImmutableNode node = this.createDefaultNode(VALUE);
        Assertions.assertSame((Object)node, (Object)node.removeChild(null));
    }

    @Test
    void testReplaceChildExisting() {
        ImmutableNode childRemove = this.createChild();
        ImmutableNode childReplace = this.createChild();
        ImmutableNode node = this.createDefaultNode(VALUE).addChild(childRemove);
        ImmutableNode node2 = node.replaceChild(childRemove, childReplace);
        TestImmutableNode.checkUpdatedNode(node, node2);
        TestImmutableNode.checkChildNodes(node2, (ImmutableNode)node.getChildren().get(0), childReplace);
    }

    @Test
    void testReplaceChildNotExisting() {
        ImmutableNode node = this.createDefaultNode(VALUE);
        Assertions.assertSame((Object)node, (Object)node.replaceChild(this.createChild(), this.createChild()));
    }

    @Test
    void testReplaceChildNull() {
        ImmutableNode node = this.createDefaultNode(VALUE);
        ImmutableNode child = this.createChild();
        Assertions.assertThrows(IllegalArgumentException.class, () -> node.replaceChild(child, null));
    }

    @Test
    void testReplaceChildren() {
        int childCount = 8;
        ArrayList<ImmutableNode> newChildren = new ArrayList<ImmutableNode>(8);
        for (int i = 0; i < 8; ++i) {
            newChildren.add(this.createChild());
        }
        ImmutableNode node = this.createDefaultNode(VALUE);
        ImmutableNode node2 = node.replaceChildren(newChildren);
        TestImmutableNode.checkUpdatedNode(node, node2);
        TestImmutableNode.checkChildNodes(node2, newChildren);
    }

    @Test
    void testReplaceChildrenNullCollection() {
        ImmutableNode node = this.createDefaultNode(VALUE);
        ImmutableNode node2 = node.replaceChildren(null);
        TestImmutableNode.checkUpdatedNode(node, node2);
        TestImmutableNode.checkChildNodes(node2, new ImmutableNode[0]);
    }

    @Test
    void testSetAttribute() {
        ImmutableNode node = this.createDefaultNode(VALUE);
        ImmutableNode node2 = node.setAttribute(ATTR, (Object)ATTR_VALUE);
        TestImmutableNode.checkUpdatedNode(node, node2);
        Assertions.assertSame((Object)node.getChildren(), (Object)node2.getChildren());
        HashMap<String, String> newAttrs = new HashMap<String, String>(node.getAttributes());
        newAttrs.put(ATTR, ATTR_VALUE);
        TestImmutableNode.checkAttributes(node2, newAttrs);
    }

    @Test
    void testSetAttributeOverride() {
        ImmutableNode.Builder builder = TestImmutableNode.setUpBuilder();
        String attr2 = "attr_other";
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put(ATTR, ATTR_VALUE);
        attrs.put("attr_other", "someValue");
        ImmutableNode node = builder.addAttributes(attrs).create();
        ImmutableNode node2 = node.setAttribute("attr_other", (Object)VALUE);
        attrs.put("attr_other", VALUE);
        TestImmutableNode.checkAttributes(node2, attrs);
    }

    @Test
    void testSetAttributes() {
        ImmutableNode node = this.createDefaultNode(VALUE);
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("newAttribute1", "value1");
        attributes.put("newAttribute2", "value2");
        ImmutableNode node2 = node.setAttributes(attributes);
        Assertions.assertEquals((int)(attributes.size() + node.getAttributes().size()), (int)node2.getAttributes().size());
        TestImmutableNode.checkAttributesContained(node2, attributes);
        TestImmutableNode.checkAttributesContained(node2, node.getAttributes());
    }

    @Test
    void testSetAttributesEmpty() {
        this.checkSetAttributesNoOp(new HashMap<String, Object>());
    }

    @Test
    void testSetAttributesNull() {
        this.checkSetAttributesNoOp(null);
    }

    @Test
    void testSetName() {
        ImmutableNode node = this.createDefaultNode("anotherName", VALUE);
        ImmutableNode node2 = node.setName(NAME);
        TestImmutableNode.checkUpdatedNode(node, node2);
        Assertions.assertSame((Object)node.getChildren(), (Object)node2.getChildren());
        Assertions.assertSame((Object)node.getAttributes(), (Object)node2.getAttributes());
    }

    @Test
    void testSetValue() {
        ImmutableNode node = this.createDefaultNode("test");
        ImmutableNode node2 = node.setValue((Object)VALUE);
        TestImmutableNode.checkUpdatedNode(node, node2);
        Assertions.assertSame((Object)node.getChildren(), (Object)node2.getChildren());
        Assertions.assertSame((Object)node.getAttributes(), (Object)node2.getAttributes());
    }

    @Test
    void testSimpleProperties() {
        ImmutableNode node = TestImmutableNode.setUpBuilder().create();
        Assertions.assertEquals((Object)NAME, (Object)node.getNodeName());
        Assertions.assertTrue((boolean)node.getChildren().isEmpty());
        Assertions.assertTrue((boolean)node.getAttributes().isEmpty());
    }

    @Test
    void testStream() {
        ImmutableNode node = this.createDefaultNode(VALUE);
        ImmutableNode child2 = new ImmutableNode.Builder().name("child2").create();
        ImmutableNode node2 = node.addChild(child2);
        TestImmutableNode.checkUpdatedNode(node, node2);
        Assertions.assertEquals((long)1L, (long)node.stream().count());
        Assertions.assertEquals((long)0L, (long)child2.stream().count());
        Assertions.assertEquals((long)2L, (long)node2.stream().count());
        Assertions.assertEquals((long)1L, (long)node.stream().count());
    }
}

