/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import org.apache.commons.io.output.NullOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class NullOutputStreamTest {
    NullOutputStreamTest() {
    }

    private void process(NullOutputStream nos) throws IOException {
        nos.write("string".getBytes());
        nos.write("some string".getBytes(), 3, 5);
        nos.write(1);
        nos.write(15);
        nos.flush();
        nos.close();
        nos.write("allowed".getBytes());
        nos.write(255);
        byte[] b = new byte[1];
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> nos.write(b, -1, 0));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> nos.write(b, 0, -1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> nos.write(b, 0, 2));
        Assertions.assertThrows(NullPointerException.class, () -> nos.write(null, 0, 0));
    }

    @Test
    void testNewInstance() throws IOException {
        try (NullOutputStream nos = new NullOutputStream();){
            this.process(nos);
        }
    }

    @Test
    void testSingleton() throws IOException {
        try (NullOutputStream nos = NullOutputStream.INSTANCE;){
            this.process(nos);
        }
    }
}

