/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import org.apache.commons.text.similarity.JaccardDistance;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class JaccardDistanceTest {
    private static JaccardDistance classBeingTested;

    @BeforeAll
    public static void setUp() {
        classBeingTested = new JaccardDistance();
    }

    @Test
    public void testGettingJaccardDistance() {
        org.junit.jupiter.api.Assertions.assertEquals((double)1.0, (double)classBeingTested.apply((CharSequence)"", (CharSequence)""), (double)1.0E-20);
        org.junit.jupiter.api.Assertions.assertEquals((double)1.0, (double)classBeingTested.apply((CharSequence)"left", (CharSequence)""), (double)1.0E-20);
        org.junit.jupiter.api.Assertions.assertEquals((double)1.0, (double)classBeingTested.apply((CharSequence)"", (CharSequence)"right"), (double)1.0E-20);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.25, (double)classBeingTested.apply((CharSequence)"frog", (CharSequence)"fog"), (double)1.0E-20);
        org.junit.jupiter.api.Assertions.assertEquals((double)1.0, (double)classBeingTested.apply((CharSequence)"fly", (CharSequence)"ant"), (double)1.0E-20);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.78, (double)classBeingTested.apply((CharSequence)"elephant", (CharSequence)"hippo"), (double)1.0E-20);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.36, (double)classBeingTested.apply((CharSequence)"ABC Corporation", (CharSequence)"ABC Corp"), (double)1.0E-20);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.24, (double)classBeingTested.apply((CharSequence)"D N H Enterprises Inc", (CharSequence)"D & H Enterprises, Inc."), (double)1.0E-20);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.11, (double)classBeingTested.apply((CharSequence)"My Gym Children's Fitness Center", (CharSequence)"My Gym. Childrens Fitness"), (double)1.0E-20);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.1, (double)classBeingTested.apply((CharSequence)"PENNSYLVANIA", (CharSequence)"PENNCISYLVNIA"), (double)1.0E-20);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.87, (double)classBeingTested.apply((CharSequence)"left", (CharSequence)"right"), (double)1.0E-20);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.87, (double)classBeingTested.apply((CharSequence)"leettteft", (CharSequence)"ritttght"), (double)1.0E-20);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.0, (double)classBeingTested.apply((CharSequence)"the same string", (CharSequence)"the same string"), (double)1.0E-20);
    }

    @Test
    public void testGettingJaccardDistanceNullNull() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> classBeingTested.apply(null, null));
    }

    @Test
    public void testGettingJaccardDistanceStringNull() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> classBeingTested.apply((CharSequence)" ", null));
    }

    @Test
    public void testGettingJaccardDistanceNullString() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> classBeingTested.apply(null, (CharSequence)"right"));
    }
}

