/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.translate;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import org.apache.commons.text.translate.AggregateTranslator;
import org.apache.commons.text.translate.CharSequenceTranslator;
import org.apache.commons.text.translate.LookupTranslator;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class AggregateTranslatorTest {
    @Test
    public void testNullConstructor() {
        String testString = "foo";
        AggregateTranslator subject = new AggregateTranslator((CharSequenceTranslator[])null);
        Assertions.assertThat((String)subject.translate((CharSequence)"foo")).isEqualTo((Object)"foo");
    }

    @Test
    public void testNullVarargConstructor() {
        String testString = "foo";
        AggregateTranslator subject = new AggregateTranslator(new CharSequenceTranslator[]{null});
        Assertions.assertThat((String)subject.translate((CharSequence)"foo")).isEqualTo((Object)"foo");
    }

    @Test
    public void testNonNull() throws IOException {
        HashMap<String, String> oneTwoMap = new HashMap<String, String>();
        oneTwoMap.put("one", "two");
        HashMap<String, String> threeFourMap = new HashMap<String, String>();
        threeFourMap.put("three", "four");
        LookupTranslator translator1 = new LookupTranslator(oneTwoMap);
        LookupTranslator translator2 = new LookupTranslator(threeFourMap);
        AggregateTranslator subject = new AggregateTranslator(new CharSequenceTranslator[]{translator1, translator2});
        StringWriter out1 = new StringWriter();
        int result1 = subject.translate((CharSequence)new StringBuffer("one"), 0, (Writer)out1);
        ((AbstractIntegerAssert)Assertions.assertThat((int)result1).as("Incorrect codepoint consumption", new Object[0])).isEqualTo(3);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)out1.toString()).as("Incorrect value", new Object[0])).isEqualTo((Object)"two");
        StringWriter out2 = new StringWriter();
        int result2 = subject.translate((CharSequence)new StringBuffer("three"), 0, (Writer)out2);
        ((AbstractIntegerAssert)Assertions.assertThat((int)result2).as("Incorrect codepoint consumption", new Object[0])).isEqualTo(5);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)out2.toString()).as("Incorrect value", new Object[0])).isEqualTo((Object)"four");
    }
}

