/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.transaction.impl.XidImpl;
import org.apache.activemq.artemis.utils.BufferHelper;

public class XidCodecSupport {
    public static void encodeXid(Xid xid, ActiveMQBuffer out) {
        out.writeInt(xid.getFormatId());
        out.writeInt(xid.getBranchQualifier().length);
        out.writeBytes(xid.getBranchQualifier());
        out.writeInt(xid.getGlobalTransactionId().length);
        out.writeBytes(xid.getGlobalTransactionId());
    }

    public static Xid decodeXid(ActiveMQBuffer in) {
        int formatID = in.readInt();
        byte[] bq = BufferHelper.safeReadBytes(in);
        byte[] gtxid = BufferHelper.safeReadBytes(in);
        return new XidImpl(bq, formatID, gtxid);
    }

    public static int getXidEncodeLength(Xid xid) {
        return 12 + xid.getBranchQualifier().length + xid.getGlobalTransactionId().length;
    }
}

