/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.profile.logic;

import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.saml.common.profile.logic.AbstractRegistrationInfoPredicate;
import org.opensaml.saml.ext.saml2mdrpi.RegistrationInfo;
import org.opensaml.saml.ext.saml2mdrpi.RegistrationPolicy;

public class RegistrationPolicyPredicate
extends AbstractRegistrationInfoPredicate {
    @Nonnull
    private final Set<String> policySet;

    public RegistrationPolicyPredicate(@Nullable @ParameterName(name="policies") Collection<String> policies) {
        this.policySet = CollectionSupport.copyToSet((Collection)StringSupport.normalizeStringCollection(policies));
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Set<String> getPolicies() {
        return this.policySet;
    }

    @Override
    protected boolean doApply(@Nonnull RegistrationInfo info) {
        for (RegistrationPolicy policy : info.getRegistrationPolicies()) {
            if (!this.policySet.contains(policy.getURI())) continue;
            return true;
        }
        return false;
    }
}

