/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.web.panel;

import org.apache.directory.fortress.core.DelReviewMgr;
import org.apache.directory.fortress.core.ReviewMgr;
import org.apache.directory.fortress.core.model.Constraint;
import org.apache.directory.fortress.core.model.ConstraintUtil;
import org.apache.directory.fortress.core.model.UserAdminRole;
import org.apache.directory.fortress.core.model.UserRole;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.web.control.SecUtils;
import org.apache.directory.fortress.web.modal.ModalWindow;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.markup.html.navigation.paging.AjaxPagingNavigator;
import org.apache.wicket.markup.html.list.PageableListView;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleSearchModalPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    @SpringBean
    private ReviewMgr reviewMgr;
    @SpringBean
    private DelReviewMgr delReviewMgr;
    private static final Logger LOG = LoggerFactory.getLogger((String)RoleSearchModalPanel.class.getName());
    private ModalWindow window;
    private Constraint roleSelection;
    private String roleSearchVal;
    private boolean isAdmin;
    private boolean isParentSearch;

    public RoleSearchModalPanel(String id, ModalWindow window, boolean isAdmin) {
        super(id);
        this.window = window;
        this.isAdmin = isAdmin;
        if (Config.getInstance().getBoolean("is.arbac02")) {
            this.delReviewMgr.setAdmin(SecUtils.getSession((Component)this));
        }
        this.loadPanel();
    }

    public void loadPanel() {
        LoadableDetachableModel requests = this.getListViewModel();
        PageableListView roleView = this.createListView(requests);
        this.add(new Component[]{roleView});
        this.add(new Component[]{new AjaxPagingNavigator("navigator", (IPageable)roleView)});
    }

    private PageableListView createListView(LoadableDetachableModel requests) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private LoadableDetachableModel getListViewModel() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public UserRole getRoleSelection() {
        UserRole userRoleSelection = new UserRole();
        if (this.roleSelection != null) {
            userRoleSelection.setName(this.roleSelection.getName());
            ConstraintUtil.copy((Constraint)this.roleSelection, (Constraint)userRoleSelection);
        }
        return userRoleSelection;
    }

    public UserAdminRole getAdminRoleSelection() {
        UserAdminRole userRoleSelection = new UserAdminRole();
        if (this.roleSelection != null) {
            userRoleSelection.setName(this.roleSelection.getName());
            ConstraintUtil.copy((Constraint)this.roleSelection, (Constraint)userRoleSelection);
        }
        return userRoleSelection;
    }

    public void setRoleSearchVal(String roleSearchVal) {
        this.roleSearchVal = roleSearchVal;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public void setAdmin(boolean admin) {
        this.isAdmin = admin;
    }

    public boolean isParentSearch() {
        return this.isParentSearch;
    }

    public void setParentSearch(boolean parentSearch) {
        this.isParentSearch = parentSearch;
    }
}

