/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.web.panel;

import com.inmethod.grid.column.PropertyColumn;
import com.inmethod.grid.treegrid.TreeGrid;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.apache.directory.fortress.core.model.FortEntity;
import org.apache.directory.fortress.core.model.Permission;
import org.apache.directory.fortress.core.model.User;
import org.apache.directory.fortress.web.control.SecUtils;
import org.apache.directory.fortress.web.event.SaveModelEvent;
import org.apache.directory.fortress.web.modal.ModalWindow;
import org.apache.directory.fortress.web.model.UserListModel;
import org.apache.directory.fortress.web.panel.OUSearchModalPanel;
import org.apache.directory.fortress.web.panel.PermSearchModalPanel;
import org.apache.directory.fortress.web.panel.RoleSearchModalPanel;
import org.apache.directory.fortress.web.panel.UserListPanel;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.Radio;
import org.apache.wicket.markup.html.form.RadioGroup;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserListPanel<T extends Serializable>
extends FormComponentPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger((String)UserListPanel.class.getName());
    private Form listForm;
    private DefaultTreeModel treeModel;
    private DefaultMutableTreeNode node;
    private TreeGrid<DefaultTreeModel, DefaultMutableTreeNode, String> grid;
    private DefaultMutableTreeNode rootNode;
    private String selectedRadioButton;
    private TextField f1Fld;
    private TextField f2Fld;
    private Label f1Lbl;
    private Label f2Lbl;
    private Label searchFieldsLbl;
    private WebMarkupContainer userformsearchfields;
    private WebMarkupContainer searchFields;
    private RadioGroup radioGroup;
    private static final String USERS = "U";
    private static final String ROLES = "R";
    private static final String ADMIN_ROLES = "A";
    private static final String OUS = "O";
    private static final String PERMS = "P";
    private Permission permission;
    private SearchFields searchData = new SearchFields(this);
    private static final String USER_LABEL = "User ID";
    private String field1Label = "User ID";
    private String field2Label;
    private String searchFieldsLabel = "Search By User";
    private static final String USER_SEARCH_LABEL = "Search By User";

    public UserListPanel(String id) {
        super(id);
        UserListModel userListModel = new UserListModel(new User(), SecUtils.getSession((Component)this));
        this.setDefaultModel((IModel)userListModel);
        this.addGrid();
        this.userformsearchfields = new WebMarkupContainer("userformsearchfields");
        this.userformsearchfields.setOutputMarkupId(true);
        this.listForm.add(new Component[]{this.userformsearchfields});
        this.addRadioButtons();
        this.addSearchFields();
        this.addButtons();
    }

    private void addRadioButtons() {
        this.radioGroup = new RadioGroup("searchOptions", (IModel)new PropertyModel((Object)this, "selectedRadioButton"));
        1 ajaxRadioUpdater = new /* Unavailable Anonymous Inner Class!! */;
        this.radioGroup.add(new Behavior[]{ajaxRadioUpdater});
        this.add(new Component[]{this.radioGroup});
        Radio userRb = new Radio("userRb", (IModel)new Model((Serializable)((Object)USERS)));
        this.radioGroup.add(new Component[]{userRb});
        Radio roleRb = new Radio("roleRb", (IModel)new Model((Serializable)((Object)ROLES)));
        this.radioGroup.add(new Component[]{roleRb});
        Radio adminRoleRb = new Radio("adminRoleRb", (IModel)new Model((Serializable)((Object)ADMIN_ROLES)));
        this.radioGroup.add(new Component[]{adminRoleRb});
        Radio ouRb = new Radio("ouRb", (IModel)new Model((Serializable)((Object)OUS)));
        this.radioGroup.add(new Component[]{ouRb});
        Radio permRb = new Radio("permRb", (IModel)new Model((Serializable)((Object)PERMS)));
        this.radioGroup.add(new Component[]{permRb});
        this.radioGroup.setOutputMarkupId(true);
        this.radioGroup.setRenderBodyOnly(false);
        this.userformsearchfields.add(new Component[]{this.radioGroup});
        this.selectedRadioButton = USERS;
        this.addRoleSearchModal(roleRb);
        this.addAdminRoleSearchModal(adminRoleRb);
        this.addOUSearchModal(ouRb);
        this.addPermSearchModal(permRb);
    }

    private void addSearchFields() {
        this.searchFields = new WebMarkupContainer("searchfields");
        this.searchFieldsLbl = new Label("searchFieldslabel", (IModel)new PropertyModel((Object)this, "searchFieldsLabel"));
        this.searchFields.add(new Component[]{this.searchFieldsLbl});
        this.f1Lbl = new Label("field1label", (IModel)new PropertyModel((Object)this, "field1Label"));
        this.searchFields.add(new Component[]{this.f1Lbl});
        this.f2Lbl = new Label("field2label", (IModel)new PropertyModel((Object)this, "field2Label"));
        this.searchFields.add(new Component[]{this.f2Lbl});
        this.f1Fld = new TextField("field1", (IModel)new PropertyModel((Object)this, "searchData.field1"));
        this.f1Fld.setOutputMarkupId(true);
        2 ajaxUpdater = new /* Unavailable Anonymous Inner Class!! */;
        this.f1Fld.add(new Behavior[]{ajaxUpdater});
        this.searchFields.add(new Component[]{this.f1Fld});
        this.f2Fld = new TextField("field2", (IModel)new PropertyModel((Object)this, "searchData.field2"));
        this.f2Fld.setOutputMarkupId(true);
        ajaxUpdater = new /* Unavailable Anonymous Inner Class!! */;
        this.f2Fld.add(new Behavior[]{ajaxUpdater});
        this.f2Fld.setVisible(false);
        this.searchFields.add(new Component[]{this.f2Fld});
        this.searchFields.setOutputMarkupId(true);
        this.userformsearchfields.add(new Component[]{this.searchFields});
    }

    private void addButtons() {
        this.userformsearchfields.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        this.userformsearchfields.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
    }

    private void addRoleSearchModal(Radio roleRb) {
        Component[] componentArray = new Component[1];
        ModalWindow rolesModalWindow = new ModalWindow("rolesearchmodal");
        componentArray[0] = rolesModalWindow;
        this.userformsearchfields.add(componentArray);
        RoleSearchModalPanel roleSearchModalPanel = new RoleSearchModalPanel(rolesModalWindow.getContentId(), rolesModalWindow, false);
        rolesModalWindow.setContent((Component)roleSearchModalPanel);
        rolesModalWindow.setWindowClosedCallback((ModalWindow.WindowClosedCallback)new /* Unavailable Anonymous Inner Class!! */);
        roleRb.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        rolesModalWindow.setTitle("RBAC Role Search Modal");
        rolesModalWindow.setInitialWidth(700);
        rolesModalWindow.setInitialHeight(700);
        rolesModalWindow.setCookieName("role-assign-modal");
    }

    private void addAdminRoleSearchModal(Radio adminRoleRb) {
        Component[] componentArray = new Component[1];
        ModalWindow adminRolesModalWindow = new ModalWindow("adminrolesearchmodal");
        componentArray[0] = adminRolesModalWindow;
        this.userformsearchfields.add(componentArray);
        RoleSearchModalPanel adminRoleSearchModalPanel = new RoleSearchModalPanel(adminRolesModalWindow.getContentId(), adminRolesModalWindow, true);
        adminRolesModalWindow.setContent((Component)adminRoleSearchModalPanel);
        adminRolesModalWindow.setWindowClosedCallback((ModalWindow.WindowClosedCallback)new /* Unavailable Anonymous Inner Class!! */);
        adminRoleRb.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        adminRolesModalWindow.setTitle("Admin Role Search Modal");
        adminRolesModalWindow.setInitialWidth(700);
        adminRolesModalWindow.setInitialHeight(700);
        adminRolesModalWindow.setCookieName("role-assign-modal");
    }

    private void addOUSearchModal(Radio ouRb) {
        Component[] componentArray = new Component[1];
        ModalWindow ousModalWindow = new ModalWindow("ousearchmodal");
        componentArray[0] = ousModalWindow;
        this.userformsearchfields.add(componentArray);
        OUSearchModalPanel ouSearchModalPanel = new OUSearchModalPanel(ousModalWindow.getContentId(), ousModalWindow, true);
        ousModalWindow.setContent((Component)ouSearchModalPanel);
        ousModalWindow.setWindowClosedCallback((ModalWindow.WindowClosedCallback)new /* Unavailable Anonymous Inner Class!! */);
        ouRb.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        ousModalWindow.setTitle("User Organizational Unit Search Modal");
        ousModalWindow.setInitialWidth(450);
        ousModalWindow.setInitialHeight(450);
        ousModalWindow.setCookieName("userou-modal");
    }

    public void onEvent(IEvent event) {
        if (event.getPayload() instanceof SaveModelEvent) {
            SaveModelEvent modelEvent = (SaveModelEvent)event.getPayload();
            switch (15.$SwitchMap$org$apache$directory$fortress$web$event$SaveModelEvent$Operations[modelEvent.getOperation().ordinal()]) {
                case 1: {
                    this.add(modelEvent.getEntity());
                    break;
                }
                case 2: {
                    this.modelChanged();
                    break;
                }
                case 3: {
                    this.prune();
                    break;
                }
                default: {
                    LOG.error("onEvent caught invalid operation");
                }
            }
            AjaxRequestTarget target = ((SaveModelEvent)event.getPayload()).getAjaxRequestTarget();
            target.add(new Component[]{this.grid});
            LOG.debug(".onEvent AJAX - UserListPanel - SaveModelEvent: " + target.toString());
        }
    }

    private void addPermSearchModal(Radio permRb) {
        Component[] componentArray = new Component[1];
        ModalWindow permsModalWindow = new ModalWindow("permsearchmodal");
        componentArray[0] = permsModalWindow;
        this.userformsearchfields.add(componentArray);
        PermSearchModalPanel permSearchModalPanel = new PermSearchModalPanel(permsModalWindow.getContentId(), permsModalWindow, false);
        permsModalWindow.setContent((Component)permSearchModalPanel);
        permsModalWindow.setWindowClosedCallback((ModalWindow.WindowClosedCallback)new /* Unavailable Anonymous Inner Class!! */);
        permRb.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        permsModalWindow.setTitle("Permission Search Modal");
        permsModalWindow.setInitialWidth(650);
        permsModalWindow.setInitialHeight(450);
        permsModalWindow.setCookieName("perm-search-modal");
    }

    private void removeSelectedItems(TreeGrid<DefaultTreeModel, DefaultMutableTreeNode, String> grid) {
        Collection selected = grid.getSelectedItems();
        for (IModel model : selected) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)model.getObject();
            this.treeModel.removeNodeFromParent(node);
            User user = (User)node.getUserObject();
            LOG.debug(".removeSelectedItems user node: " + user.getUserId());
            List users = (List)this.getDefaultModel().getObject();
            users.remove(user);
        }
    }

    private DefaultTreeModel createTreeModel(List<T> users) {
        this.rootNode = new DefaultMutableTreeNode(null);
        DefaultTreeModel model = new DefaultTreeModel(this.rootNode);
        if (users == null) {
            LOG.debug("no Users found");
        } else {
            LOG.debug(".createTreeModel Users found:" + users.size());
            for (Serializable user : users) {
                this.rootNode.add(new DefaultMutableTreeNode(user));
            }
        }
        return model;
    }

    private void addGrid() {
        ArrayList<PropertyColumn> columns = new ArrayList<PropertyColumn>();
        columns.add(new PropertyColumn((IModel)Model.of((Serializable)((Object)"UserId")), "userObject.UserId"));
        PropertyColumn ou = new PropertyColumn((IModel)Model.of((Serializable)((Object)"User Organization")), "userObject.Ou");
        ou.setInitialSize(150);
        columns.add(ou);
        columns.add(new PropertyColumn((IModel)Model.of((Serializable)((Object)"Description")), "userObject.Description"));
        columns.add(new PropertyColumn((IModel)Model.of((Serializable)((Object)"Address")), "userObject.Address.Addresses"));
        columns.add(new PropertyColumn((IModel)Model.of((Serializable)((Object)"City")), "userObject.Address.City"));
        PropertyColumn state = new PropertyColumn((IModel)Model.of((Serializable)((Object)"State")), "userObject.Address.State");
        state.setInitialSize(50);
        columns.add(state);
        PropertyColumn roles = new PropertyColumn((IModel)Model.of((Serializable)((Object)"RBAC Role Assignments")), "userObject.Roles");
        roles.setInitialSize(400);
        columns.add(roles);
        PropertyColumn adminRoles = new PropertyColumn((IModel)Model.of((Serializable)((Object)"Admin Role Assignments")), "userObject.AdminRoles");
        adminRoles.setInitialSize(400);
        columns.add(adminRoles);
        List users = (List)this.getDefaultModel().getObject();
        this.treeModel = this.createTreeModel(users);
        this.grid = new /* Unavailable Anonymous Inner Class!! */;
        this.grid.setAllowSelectMultiple(false);
        this.grid.setClickRowToSelect(true);
        this.grid.setClickRowToDeselect(false);
        this.grid.setSelectToEdit(false);
        this.grid.getTreeState().expandAll();
        this.listForm = new Form("userlistform");
        this.listForm.add(new Component[]{this.grid});
        this.add(new Component[]{this.listForm});
        this.grid.setOutputMarkupId(true);
    }

    public void add(FortEntity entity) {
        if (this.getDefaultModelObject() != null) {
            List users = (List)this.getDefaultModelObject();
            users.add((User)entity);
            LOG.debug("UserListPanel.add tree depth: " + this.rootNode.getChildCount());
            this.treeModel.insertNodeInto(new DefaultMutableTreeNode(entity), this.rootNode, this.rootNode.getChildCount());
        }
    }

    public void prune() {
        this.removeSelectedItems(this.grid);
    }

    private void enableOuSearch() {
        String OU_SEARCH_LABEL;
        String OU_LABEL;
        this.f2Fld.setVisible(false);
        this.f2Lbl.setVisible(false);
        this.field1Label = OU_LABEL = "Organization";
        this.searchFieldsLabel = OU_SEARCH_LABEL = "Search By User Organization";
    }

    private void enableAdminSearch() {
        String ADMIN_SEARCH_LABEL;
        String ADMIN_LABEL;
        this.f2Fld.setVisible(false);
        this.f2Lbl.setVisible(false);
        this.field1Label = ADMIN_LABEL = "Admin Role Name";
        this.searchFieldsLabel = ADMIN_SEARCH_LABEL = "Search By Admininstrative Role";
    }

    private void enableRoleSearch() {
        String ROLE_SEARCH_LABEL;
        String ROLE_LABEL;
        this.f2Fld.setVisible(false);
        this.f2Lbl.setVisible(false);
        this.field1Label = ROLE_LABEL = "Role Name";
        this.searchFieldsLabel = ROLE_SEARCH_LABEL = "Search By Role";
    }

    private void enableUserSearch() {
        this.f2Fld.setVisible(false);
        this.f2Lbl.setVisible(false);
        this.field1Label = USER_LABEL;
        this.searchFieldsLabel = USER_SEARCH_LABEL;
    }

    private void enablePermSearch() {
        String PERM_SEARCH_LABEL;
        String PERM_OP_LABEL;
        String PERM_OBJ_LABEL;
        this.f2Fld.setVisible(true);
        this.f2Lbl.setVisible(true);
        this.field1Label = PERM_OBJ_LABEL = "Object Name";
        this.field2Label = PERM_OP_LABEL = "Operation Name";
        this.searchFieldsLabel = PERM_SEARCH_LABEL = "Search By Permission";
    }

    private void processRadioButton(AjaxRequestTarget target) {
        LOG.debug("RADIO Button: " + this.selectedRadioButton);
        if (this.selectedRadioButton.equals(USERS)) {
            this.enableUserSearch();
        } else if (this.selectedRadioButton.equals(ROLES)) {
            this.enableRoleSearch();
        } else if (this.selectedRadioButton.equals(ADMIN_ROLES)) {
            this.enableAdminSearch();
        } else if (this.selectedRadioButton.equals(OUS)) {
            this.enableOuSearch();
        } else if (this.selectedRadioButton.equals(PERMS)) {
            this.enablePermSearch();
        }
        this.searchData = new SearchFields(this);
        target.add(new Component[]{this.searchFields});
    }
}

