/*
 * Decompiled with CFR 0.152.
 */
package io.github.ollama4j.tools;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.github.ollama4j.tools.ToolFunction;
import io.github.ollama4j.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Tools {

    public static class PromptBuilder {
        private final List<PromptFuncDefinition> tools = new ArrayList<PromptFuncDefinition>();
        private String promptText;

        public String build() throws JsonProcessingException {
            return "[AVAILABLE_TOOLS] " + Utils.getObjectMapper().writeValueAsString(this.tools) + "[/AVAILABLE_TOOLS][INST] " + this.promptText + " [/INST]";
        }

        public PromptBuilder withPrompt(String prompt) throws JsonProcessingException {
            this.promptText = prompt;
            return this;
        }

        public PromptBuilder withToolSpecification(ToolSpecification spec) {
            PromptFuncDefinition def = new PromptFuncDefinition();
            def.setType("function");
            PromptFuncDefinition.PromptFuncSpec functionDetail = new PromptFuncDefinition.PromptFuncSpec();
            functionDetail.setName(spec.getFunctionName());
            functionDetail.setDescription(spec.getFunctionDescription());
            PromptFuncDefinition.Parameters parameters = new PromptFuncDefinition.Parameters();
            parameters.setType("object");
            parameters.setProperties(spec.getToolPrompt().getFunction().parameters.getProperties());
            ArrayList<String> requiredValues = new ArrayList<String>();
            for (Map.Entry<String, PromptFuncDefinition.Property> p : spec.getToolPrompt().getFunction().getParameters().getProperties().entrySet()) {
                if (!p.getValue().isRequired()) continue;
                requiredValues.add(p.getKey());
            }
            parameters.setRequired(requiredValues);
            functionDetail.setParameters(parameters);
            def.setFunction(functionDetail);
            this.tools.add(def);
            return this;
        }
    }

    public static class PropsBuilder {
        private final Map<String, PromptFuncDefinition.Property> props = new HashMap<String, PromptFuncDefinition.Property>();

        public PropsBuilder withProperty(String key, PromptFuncDefinition.Property property) {
            this.props.put(key, property);
            return this;
        }

        public Map<String, PromptFuncDefinition.Property> build() {
            return this.props;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PromptFuncDefinition {
        private String type;
        private PromptFuncSpec function;

        @Generated
        public static PromptFuncDefinitionBuilder builder() {
            return new PromptFuncDefinitionBuilder();
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public PromptFuncSpec getFunction() {
            return this.function;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setFunction(PromptFuncSpec function) {
            this.function = function;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PromptFuncDefinition)) {
                return false;
            }
            PromptFuncDefinition other = (PromptFuncDefinition)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            PromptFuncSpec this$function = this.getFunction();
            PromptFuncSpec other$function = other.getFunction();
            return !(this$function == null ? other$function != null : !((Object)this$function).equals(other$function));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PromptFuncDefinition;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            PromptFuncSpec $function = this.getFunction();
            result = result * 59 + ($function == null ? 43 : ((Object)$function).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Tools.PromptFuncDefinition(type=" + this.getType() + ", function=" + String.valueOf(this.getFunction()) + ")";
        }

        @Generated
        public PromptFuncDefinition() {
        }

        @Generated
        public PromptFuncDefinition(String type, PromptFuncSpec function) {
            this.type = type;
            this.function = function;
        }

        @Generated
        public static class PromptFuncDefinitionBuilder {
            @Generated
            private String type;
            @Generated
            private PromptFuncSpec function;

            @Generated
            PromptFuncDefinitionBuilder() {
            }

            @Generated
            public PromptFuncDefinitionBuilder type(String type) {
                this.type = type;
                return this;
            }

            @Generated
            public PromptFuncDefinitionBuilder function(PromptFuncSpec function) {
                this.function = function;
                return this;
            }

            @Generated
            public PromptFuncDefinition build() {
                return new PromptFuncDefinition(this.type, this.function);
            }

            @Generated
            public String toString() {
                return "Tools.PromptFuncDefinition.PromptFuncDefinitionBuilder(type=" + this.type + ", function=" + String.valueOf(this.function) + ")";
            }
        }

        public static class PromptFuncSpec {
            private String name;
            private String description;
            private Parameters parameters;

            @Generated
            public static PromptFuncSpecBuilder builder() {
                return new PromptFuncSpecBuilder();
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public String getDescription() {
                return this.description;
            }

            @Generated
            public Parameters getParameters() {
                return this.parameters;
            }

            @Generated
            public void setName(String name) {
                this.name = name;
            }

            @Generated
            public void setDescription(String description) {
                this.description = description;
            }

            @Generated
            public void setParameters(Parameters parameters) {
                this.parameters = parameters;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PromptFuncSpec)) {
                    return false;
                }
                PromptFuncSpec other = (PromptFuncSpec)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$name = this.getName();
                String other$name = other.getName();
                if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                    return false;
                }
                String this$description = this.getDescription();
                String other$description = other.getDescription();
                if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                    return false;
                }
                Parameters this$parameters = this.getParameters();
                Parameters other$parameters = other.getParameters();
                return !(this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof PromptFuncSpec;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                String $description = this.getDescription();
                result = result * 59 + ($description == null ? 43 : $description.hashCode());
                Parameters $parameters = this.getParameters();
                result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Tools.PromptFuncDefinition.PromptFuncSpec(name=" + this.getName() + ", description=" + this.getDescription() + ", parameters=" + String.valueOf(this.getParameters()) + ")";
            }

            @Generated
            public PromptFuncSpec() {
            }

            @Generated
            public PromptFuncSpec(String name, String description, Parameters parameters) {
                this.name = name;
                this.description = description;
                this.parameters = parameters;
            }

            @Generated
            public static class PromptFuncSpecBuilder {
                @Generated
                private String name;
                @Generated
                private String description;
                @Generated
                private Parameters parameters;

                @Generated
                PromptFuncSpecBuilder() {
                }

                @Generated
                public PromptFuncSpecBuilder name(String name) {
                    this.name = name;
                    return this;
                }

                @Generated
                public PromptFuncSpecBuilder description(String description) {
                    this.description = description;
                    return this;
                }

                @Generated
                public PromptFuncSpecBuilder parameters(Parameters parameters) {
                    this.parameters = parameters;
                    return this;
                }

                @Generated
                public PromptFuncSpec build() {
                    return new PromptFuncSpec(this.name, this.description, this.parameters);
                }

                @Generated
                public String toString() {
                    return "Tools.PromptFuncDefinition.PromptFuncSpec.PromptFuncSpecBuilder(name=" + this.name + ", description=" + this.description + ", parameters=" + String.valueOf(this.parameters) + ")";
                }
            }
        }

        public static class Property {
            private String type;
            private String description;
            @JsonProperty(value="enum")
            @JsonInclude(value=JsonInclude.Include.NON_NULL)
            private List<String> enumValues;
            @JsonIgnore
            private boolean required;

            @Generated
            public static PropertyBuilder builder() {
                return new PropertyBuilder();
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public String getDescription() {
                return this.description;
            }

            @Generated
            public List<String> getEnumValues() {
                return this.enumValues;
            }

            @Generated
            public boolean isRequired() {
                return this.required;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public void setDescription(String description) {
                this.description = description;
            }

            @JsonProperty(value="enum")
            @Generated
            public void setEnumValues(List<String> enumValues) {
                this.enumValues = enumValues;
            }

            @JsonIgnore
            @Generated
            public void setRequired(boolean required) {
                this.required = required;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Property)) {
                    return false;
                }
                Property other = (Property)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.isRequired() != other.isRequired()) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                    return false;
                }
                String this$description = this.getDescription();
                String other$description = other.getDescription();
                if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                    return false;
                }
                List<String> this$enumValues = this.getEnumValues();
                List<String> other$enumValues = other.getEnumValues();
                return !(this$enumValues == null ? other$enumValues != null : !((Object)this$enumValues).equals(other$enumValues));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Property;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + (this.isRequired() ? 79 : 97);
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                String $description = this.getDescription();
                result = result * 59 + ($description == null ? 43 : $description.hashCode());
                List<String> $enumValues = this.getEnumValues();
                result = result * 59 + ($enumValues == null ? 43 : ((Object)$enumValues).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Tools.PromptFuncDefinition.Property(type=" + this.getType() + ", description=" + this.getDescription() + ", enumValues=" + String.valueOf(this.getEnumValues()) + ", required=" + this.isRequired() + ")";
            }

            @Generated
            public Property() {
            }

            @Generated
            public Property(String type, String description, List<String> enumValues, boolean required) {
                this.type = type;
                this.description = description;
                this.enumValues = enumValues;
                this.required = required;
            }

            @Generated
            public static class PropertyBuilder {
                @Generated
                private String type;
                @Generated
                private String description;
                @Generated
                private List<String> enumValues;
                @Generated
                private boolean required;

                @Generated
                PropertyBuilder() {
                }

                @Generated
                public PropertyBuilder type(String type) {
                    this.type = type;
                    return this;
                }

                @Generated
                public PropertyBuilder description(String description) {
                    this.description = description;
                    return this;
                }

                @JsonProperty(value="enum")
                @Generated
                public PropertyBuilder enumValues(List<String> enumValues) {
                    this.enumValues = enumValues;
                    return this;
                }

                @JsonIgnore
                @Generated
                public PropertyBuilder required(boolean required) {
                    this.required = required;
                    return this;
                }

                @Generated
                public Property build() {
                    return new Property(this.type, this.description, this.enumValues, this.required);
                }

                @Generated
                public String toString() {
                    return "Tools.PromptFuncDefinition.Property.PropertyBuilder(type=" + this.type + ", description=" + this.description + ", enumValues=" + String.valueOf(this.enumValues) + ", required=" + this.required + ")";
                }
            }
        }

        public static class Parameters {
            private String type;
            private Map<String, Property> properties;
            private List<String> required;

            @Generated
            public static ParametersBuilder builder() {
                return new ParametersBuilder();
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public Map<String, Property> getProperties() {
                return this.properties;
            }

            @Generated
            public List<String> getRequired() {
                return this.required;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public void setProperties(Map<String, Property> properties) {
                this.properties = properties;
            }

            @Generated
            public void setRequired(List<String> required) {
                this.required = required;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Parameters)) {
                    return false;
                }
                Parameters other = (Parameters)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                    return false;
                }
                Map<String, Property> this$properties = this.getProperties();
                Map<String, Property> other$properties = other.getProperties();
                if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
                    return false;
                }
                List<String> this$required = this.getRequired();
                List<String> other$required = other.getRequired();
                return !(this$required == null ? other$required != null : !((Object)this$required).equals(other$required));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Parameters;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                Map<String, Property> $properties = this.getProperties();
                result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
                List<String> $required = this.getRequired();
                result = result * 59 + ($required == null ? 43 : ((Object)$required).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Tools.PromptFuncDefinition.Parameters(type=" + this.getType() + ", properties=" + String.valueOf(this.getProperties()) + ", required=" + String.valueOf(this.getRequired()) + ")";
            }

            @Generated
            public Parameters() {
            }

            @Generated
            public Parameters(String type, Map<String, Property> properties, List<String> required) {
                this.type = type;
                this.properties = properties;
                this.required = required;
            }

            @Generated
            public static class ParametersBuilder {
                @Generated
                private String type;
                @Generated
                private Map<String, Property> properties;
                @Generated
                private List<String> required;

                @Generated
                ParametersBuilder() {
                }

                @Generated
                public ParametersBuilder type(String type) {
                    this.type = type;
                    return this;
                }

                @Generated
                public ParametersBuilder properties(Map<String, Property> properties) {
                    this.properties = properties;
                    return this;
                }

                @Generated
                public ParametersBuilder required(List<String> required) {
                    this.required = required;
                    return this;
                }

                @Generated
                public Parameters build() {
                    return new Parameters(this.type, this.properties, this.required);
                }

                @Generated
                public String toString() {
                    return "Tools.PromptFuncDefinition.Parameters.ParametersBuilder(type=" + this.type + ", properties=" + String.valueOf(this.properties) + ", required=" + String.valueOf(this.required) + ")";
                }
            }
        }
    }

    public static class ToolSpecification {
        private String functionName;
        private String functionDescription;
        private PromptFuncDefinition toolPrompt;
        private ToolFunction toolFunction;

        @Generated
        ToolSpecification(String functionName, String functionDescription, PromptFuncDefinition toolPrompt, ToolFunction toolFunction) {
            this.functionName = functionName;
            this.functionDescription = functionDescription;
            this.toolPrompt = toolPrompt;
            this.toolFunction = toolFunction;
        }

        @Generated
        public static ToolSpecificationBuilder builder() {
            return new ToolSpecificationBuilder();
        }

        @Generated
        public String getFunctionName() {
            return this.functionName;
        }

        @Generated
        public String getFunctionDescription() {
            return this.functionDescription;
        }

        @Generated
        public PromptFuncDefinition getToolPrompt() {
            return this.toolPrompt;
        }

        @Generated
        public ToolFunction getToolFunction() {
            return this.toolFunction;
        }

        @Generated
        public void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        @Generated
        public void setFunctionDescription(String functionDescription) {
            this.functionDescription = functionDescription;
        }

        @Generated
        public void setToolPrompt(PromptFuncDefinition toolPrompt) {
            this.toolPrompt = toolPrompt;
        }

        @Generated
        public void setToolFunction(ToolFunction toolFunction) {
            this.toolFunction = toolFunction;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ToolSpecification)) {
                return false;
            }
            ToolSpecification other = (ToolSpecification)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$functionName = this.getFunctionName();
            String other$functionName = other.getFunctionName();
            if (this$functionName == null ? other$functionName != null : !this$functionName.equals(other$functionName)) {
                return false;
            }
            String this$functionDescription = this.getFunctionDescription();
            String other$functionDescription = other.getFunctionDescription();
            if (this$functionDescription == null ? other$functionDescription != null : !this$functionDescription.equals(other$functionDescription)) {
                return false;
            }
            PromptFuncDefinition this$toolPrompt = this.getToolPrompt();
            PromptFuncDefinition other$toolPrompt = other.getToolPrompt();
            if (this$toolPrompt == null ? other$toolPrompt != null : !((Object)this$toolPrompt).equals(other$toolPrompt)) {
                return false;
            }
            ToolFunction this$toolFunction = this.getToolFunction();
            ToolFunction other$toolFunction = other.getToolFunction();
            return !(this$toolFunction == null ? other$toolFunction != null : !this$toolFunction.equals(other$toolFunction));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ToolSpecification;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $functionName = this.getFunctionName();
            result = result * 59 + ($functionName == null ? 43 : $functionName.hashCode());
            String $functionDescription = this.getFunctionDescription();
            result = result * 59 + ($functionDescription == null ? 43 : $functionDescription.hashCode());
            PromptFuncDefinition $toolPrompt = this.getToolPrompt();
            result = result * 59 + ($toolPrompt == null ? 43 : ((Object)$toolPrompt).hashCode());
            ToolFunction $toolFunction = this.getToolFunction();
            result = result * 59 + ($toolFunction == null ? 43 : $toolFunction.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Tools.ToolSpecification(functionName=" + this.getFunctionName() + ", functionDescription=" + this.getFunctionDescription() + ", toolPrompt=" + String.valueOf(this.getToolPrompt()) + ", toolFunction=" + String.valueOf(this.getToolFunction()) + ")";
        }

        @Generated
        public static class ToolSpecificationBuilder {
            @Generated
            private String functionName;
            @Generated
            private String functionDescription;
            @Generated
            private PromptFuncDefinition toolPrompt;
            @Generated
            private ToolFunction toolFunction;

            @Generated
            ToolSpecificationBuilder() {
            }

            @Generated
            public ToolSpecificationBuilder functionName(String functionName) {
                this.functionName = functionName;
                return this;
            }

            @Generated
            public ToolSpecificationBuilder functionDescription(String functionDescription) {
                this.functionDescription = functionDescription;
                return this;
            }

            @Generated
            public ToolSpecificationBuilder toolPrompt(PromptFuncDefinition toolPrompt) {
                this.toolPrompt = toolPrompt;
                return this;
            }

            @Generated
            public ToolSpecificationBuilder toolFunction(ToolFunction toolFunction) {
                this.toolFunction = toolFunction;
                return this;
            }

            @Generated
            public ToolSpecification build() {
                return new ToolSpecification(this.functionName, this.functionDescription, this.toolPrompt, this.toolFunction);
            }

            @Generated
            public String toString() {
                return "Tools.ToolSpecification.ToolSpecificationBuilder(functionName=" + this.functionName + ", functionDescription=" + this.functionDescription + ", toolPrompt=" + String.valueOf(this.toolPrompt) + ", toolFunction=" + String.valueOf(this.toolFunction) + ")";
            }
        }
    }
}

